/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.audit.struts.service;

import java.util.ArrayList;
import jp.sourceforge.gnp.audit.struts.service.IAuditService;
import jp.sourceforge.gnp.audit.struts.view.AuditView;
import jp.sourceforge.gnp.audit.struts.view.ProrateView;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.export.ProrateTaxData;

public abstract class AuditService
implements IAuditService {
    @Override
    public abstract AuditView persist(String var1, ProrateAudit var2);

    @Override
    public abstract AuditView remove(String var1, ProrateAudit var2);

    @Override
    public abstract AuditView find(String var1, ProrateAudit var2);

    @Override
    public abstract AuditView prorate(String var1, ProrateAudit var2);

    AuditView createView(String ticketNumber, ProrateAudit audit) {
        AuditView view = new AuditView();
        String couponNumber = null;
        if (ticketNumber.length() > 13) {
            couponNumber = ticketNumber.substring(13);
            ticketNumber = ticketNumber.substring(0, 13);
        }
        view.setTicketNumber(ticketNumber);
        view.setCouponNumber(couponNumber);
        if (audit == null) {
            return view;
        }
        this.setView(view, audit);
        return view;
    }

    void setView(AuditView view, ProrateAudit audit) {
        ProrateTaxData tax;
        int i;
        view.setOwnAirwayId(audit.getOwnAirwayId());
        view.setAirwayNumber(audit.getAirwayNumber());
        view.setInwardNumber(audit.getInwardNumber());
        view.setEndorsement(audit.getEndorsement());
        view.setIssueDate(audit.getIssueDate());
        view.setIssuePlace(audit.getIssuePlace());
        view.setInvoiceMonth(audit.getInvoiceMonth());
        view.setOrigin(audit.getOrigin());
        view.setDestination(audit.getDestination());
        view.setCurrency(audit.getCurrency());
        view.setTicketFare(Double.toString(audit.getTicketFare()));
        view.setSalesCurrency(audit.getSalesCurrency());
        view.setSalesFare(Double.toString(audit.getSalesFare()));
        view.setFareCalculation(audit.getFareCalculation());
        view.setTotalNuc(Double.toString(audit.getTotalNuc()));
        view.setLessAmt(Double.toString(audit.getLessAmt()));
        view.setStopOverCharge(Double.toString(audit.getStopOverCharge()));
        view.setTourCode(audit.getTourCode());
        view.setAgentCode(audit.getAgentCode());
        view.setErrorFlag(Integer.toString(audit.getErrorFlag()));
        view.setErrorString(audit.getErrorString());
        if (audit.getTax() != null && audit.getTax().length > 0) {
            for (i = 0; i < audit.getTax().length; ++i) {
                tax = audit.getTax()[i];
                view.setTaxType(i, tax.getType());
                view.setTaxAmount(i, Double.toString(tax.getAmount()));
            }
        }
        if (audit.getTaxMisc() != null && audit.getTaxMisc().length > 0) {
            for (i = 0; i < audit.getTaxMisc().length; ++i) {
                tax = audit.getTaxMisc()[i];
                view.setTaxMiscType(i, tax.getType());
                view.setTaxMiscAmount(i, Double.toString(tax.getAmount()));
            }
        }
        if (audit.isOwnAudit() && audit.isTicketing()) {
            view.setProrateType("issued by own carrier");
        } else if (audit.isOwnAudit() && audit.isInward()) {
            view.setProrateType("inward");
        } else {
            view.setProrateType("outward");
        }
        if (audit.getTraceLevel() == 10000) {
            view.setTraceLevel("detail");
        }
        if (audit.getSectors() != null && audit.getSectors().length > 0) {
            for (i = 0; i < audit.getSectors().length; ++i) {
                ProrateSector sector = audit.getSectors()[i];
                view.setStopOver(i, sector.getStopOver() == 0 ? " " : "X/");
                view.setDepCode(i, sector.getDepCode());
                view.setDestCode(i, sector.getDestCode());
                if (sector.getFareBasisFullStr() != null && sector.getFareBasisFullStr().length() > 0) {
                    view.setFareBasis(i, sector.getFareBasisFullStr());
                } else {
                    view.setFareBasis(i, sector.getFareBasis());
                }
                view.setCarrier(i, sector.getCarrier());
                view.setClassOfService(i, sector.getClassOfService());
                view.setFareComponent(i, sector.getFareComponent() < 0.0 ? "" : Double.toString(sector.getFareComponent()));
                view.setFlightNo(i, sector.getFlightNo().equals("-1") ? "" : sector.getFlightNo());
                view.setFlightDate(i, sector.getFlightDate());
                view.setClassDiffPlus(i, Double.toString(sector.getClassDiffPlus()));
                view.setSecureCharge(i, Double.toString(sector.getSecureCharge()));
                view.setSideTripPlus(i, Double.toString(sector.getSideTripPlus()));
                view.setStopOverPlus(i, Double.toString(sector.getStopOverPlus()));
            }
        }
    }

    ProrateView createProrateView(String ticketNumber, ProrateAudit audit) {
        int i;
        ProrateView view = new ProrateView();
        String couponNumber = null;
        if (ticketNumber.length() > 13) {
            couponNumber = ticketNumber.substring(13);
            ticketNumber = ticketNumber.substring(0, 13);
        }
        view.setTicketNumber(ticketNumber);
        view.setCouponNumber(couponNumber);
        if (audit == null) {
            return view;
        }
        this.setView(view, audit);
        if (audit.getTraceStrings() == null) {
            view.setTraceRows(0);
            view.setTraceString("");
        } else {
            view.setTraceRows(audit.getTraceStrings().length);
            StringBuffer traceString = new StringBuffer();
            if (audit.getTraceStrings() != null && audit.getTraceStrings().length > 0) {
                for (i = 0; i < audit.getTraceStrings().length; ++i) {
                    if (i > 0) {
                        traceString.append("\n");
                    }
                    traceString.append(audit.getTraceStrings()[i]);
                }
            }
            view.setTraceString(traceString.toString());
        }
        if (audit.getSectors() == null || audit.getSectors().length <= 0) {
            return view;
        }
        ArrayList sectorsList = new ArrayList();
        if (audit.getSectors() != null && audit.getSectors().length > 0) {
            for (i = 0; i < audit.getSectors().length; ++i) {
                ProrateSector sector = audit.getSectors()[i];
                ArrayList<String> list = new ArrayList<String>();
                list.add(sector.getStopOver() == 0 ? " " : "X/");
                list.add(sector.getDepCode());
                list.add(sector.getDestCode());
                if (sector.getFareBasisFullStr() != null && sector.getFareBasisFullStr().length() > 0) {
                    list.add(sector.getFareBasisFullStr());
                } else {
                    list.add(sector.getFareBasis());
                }
                list.add(sector.getCarrier());
                list.add(sector.getClassOfService());
                list.add(sector.getFareComponent() < 0.0 ? "" : Double.toString(sector.getFareComponent()));
                list.add(sector.getFlightNo().equals("-1") ? "" : sector.getFlightNo());
                list.add(sector.getFlightDate());
                list.add(Double.toString(sector.getProrateFactor()));
                String prorationTypeStr = "";
                int prorationType = sector.getProrationType();
                if ((prorationType & 0x1000000) != 0) {
                    prorationTypeStr = "Spa";
                    if ((prorationType & 0x100) != 0) {
                        prorationTypeStr = prorationTypeStr + "Pv";
                    }
                } else if ((prorationType & 0x2000000) != 0) {
                    prorationTypeStr = "Apd";
                } else if ((prorationType & 1) != 0) {
                    prorationTypeStr = "Srp";
                }
                if ((prorationType & 0x10000) != 0) {
                    prorationTypeStr = prorationTypeStr + "Pf";
                } else if ((prorationType & 0x20000) != 0) {
                    prorationTypeStr = prorationTypeStr + "Fx";
                } else if ((prorationType & 0x40000) != 0) {
                    prorationTypeStr = prorationTypeStr + "Fs";
                } else if ((prorationType & 0x80000) != 0) {
                    prorationTypeStr = prorationTypeStr + "Np";
                }
                if ((prorationType & 0x10000000) != 0) {
                    prorationTypeStr = prorationTypeStr + "Hig";
                } else if ((prorationType & 0x20000000) != 0) {
                    prorationTypeStr = prorationTypeStr + "Low";
                } else if ((prorationType & 0x40000000) != 0) {
                    prorationTypeStr = prorationTypeStr + "Hif";
                } else if ((prorationType & Integer.MIN_VALUE) != 0) {
                    prorationTypeStr = prorationTypeStr + "Lof";
                }
                if ((prorationType & 0x200) != 0) {
                    prorationTypeStr = prorationTypeStr + "Ml";
                } else if ((prorationType & 0x800) != 0) {
                    prorationTypeStr = prorationTypeStr + "Ml";
                }
                list.add(prorationTypeStr);
                list.add(Double.toString(sector.getProrateValue()));
                list.add(Double.toString(sector.getNpPvalues()));
                list.add(Double.toString(sector.getInvoiceValue()));
                list.add(sector.getSpaBaseAmtType());
                list.add(Double.toString(sector.getSpaBaseAmt()));
                list.add(Double.toString(sector.getSpaDay5Rate()));
                list.add(Double.toString(sector.getSpaDiscountRate()));
                list.add(Double.toString(sector.getSpaClassDiff()));
                list.add(Double.toString(sector.getSpaNuc()));
                list.add(sector.getApdpBaseAmtType());
                list.add(Double.toString(sector.getApdpBaseAmt()));
                list.add(Double.toString(sector.getApdpDay5Rate()));
                list.add(Double.toString(sector.getApdpDiscountRate()));
                list.add(Double.toString(sector.getApdpClassDiff()));
                list.add(Double.toString(sector.getApdpNuc()));
                list.add(Double.toString(sector.getSrpNuc()));
                list.add(Double.toString(sector.getProratedClassDiff()));
                list.add(Double.toString(sector.getExstPlus()));
                list.add(Double.toString(sector.getProratedExstPlus()));
                list.add(Double.toString(sector.getTax()));
                list.add(Double.toString(sector.getTaxInLocal()));
                list.add(Double.toString(sector.getCommission()));
                list.add(Double.toString(sector.getClassDiffPlus()));
                list.add(Double.toString(sector.getSecureCharge()));
                list.add(Double.toString(sector.getSideTripPlus() < 0.0 ? 0.0 : sector.getSideTripPlus()));
                list.add(Double.toString(sector.getStopOverPlus()));
                list.add(Integer.toString(sector.getProrateError()));
                list.add(Double.toString(sector.getAmountInLocal()));
                list.add(Integer.toString(sector.getSideTripIndex()));
                list.add(Integer.toString(sector.getClassDiffIndex()));
                list.add(Integer.toString(sector.getSecureIndex()));
                list.add(Double.toString(sector.getFixedFareCheck()));
                list.add(Double.toString(sector.getFixedFareDiscount()));
                list.add(Integer.toString(sector.getComponentIndex()));
                list.add(Integer.toString(sector.getComponentKind()));
                list.add(sector.getViaRouting());
                list.add(Integer.toString(sector.getFareType()));
                list.add(Integer.toString(sector.getSequenceNo()));
                list.add(sector.getOpCarrier());
                list.add(Double.toString(sector.getNpClassDiff()));
                list.add(Double.toString(sector.getSecureChargeSaved()));
                list.add(Double.toString(sector.getProratedSecureCharge()));
                list.add(Double.toString(sector.getErrorFlag()));
                list.add(sector.getErrorString());
                if (sector.getErrorFlag() > 0 || sector.getErrorString().length() > 0) {
                    String errorString = view.getErrorString();
                    if (errorString.length() > 0) {
                        errorString = errorString + "\n";
                    }
                    String sectorError = "";
                    switch (sector.getErrorFlag()) {
                        case 1: {
                            sectorError = "wrong number of arguments ";
                            view.setFatalError(true);
                            break;
                        }
                        case 2: {
                            sectorError = "illegal argument ";
                            view.setFatalError(true);
                            break;
                        }
                        case 3: {
                            sectorError = "function not defined or illegal definition ";
                            view.setFatalError(true);
                            break;
                        }
                        case 4: {
                            sectorError = "unbound variable ";
                            view.setFatalError(true);
                            break;
                        }
                        case 5: {
                            sectorError = "set multi path amount failed ";
                            view.setFatalError(true);
                            break;
                        }
                        case 6: {
                            sectorError = "baseamount data not found ";
                            break;
                        }
                        case 7: {
                            sectorError = "SET: illegal value $DISCOUNT";
                            view.setFatalError(true);
                            break;
                        }
                        case 8: {
                            sectorError = "";
                            view.setFatalError(true);
                            break;
                        }
                        case 9: {
                            sectorError = "Memory Exhausted";
                            view.setFatalError(true);
                            break;
                        }
                        case 10: {
                            sectorError = "Currency not match ";
                            view.setFatalError(true);
                            break;
                        }
                        case 31: {
                            sectorError = "";
                            view.setFatalError(true);
                            break;
                        }
                        case 65: {
                            sectorError = "cannot get AirwayId of the ticket ";
                            view.setFatalError(true);
                            break;
                        }
                        case 66: {
                            sectorError = "Prorate Factor not found ";
                            view.setFatalError(true);
                            break;
                        }
                        case 67: {
                            sectorError = "cannot get RoeRate for ";
                            view.setFatalError(true);
                            break;
                        }
                        case 68: 
                        case 69: 
                        case 70: {
                            sectorError = "cannot get 5DayRate for ";
                            view.setFatalError(true);
                            break;
                        }
                        case 71: {
                            sectorError = "cannot get CountryName for ";
                            view.setFatalError(true);
                            break;
                        }
                        case 72: {
                            sectorError = "cannot get AreaName for ";
                            view.setFatalError(true);
                            break;
                        }
                        case 73: {
                            sectorError = "cannot get FixedFare for ";
                            view.setFatalError(true);
                        }
                    }
                    sectorError = sectorError + sector.getErrorString();
                    errorString = errorString + "sector " + i + " : " + sectorError;
                    view.setErrorString(errorString);
                }
                sectorsList.add(list);
            }
        }
        view.setSectorsList(sectorsList);
        view.setFatalError(false);
        if (audit.getErrorFlag() > 0 || audit.getErrorString().length() > 0) {
            String errorString = view.getErrorString();
            if (errorString.length() > 0) {
                errorString = errorString + "\n";
            }
            String auditError = "";
            switch (audit.getErrorFlag()) {
                case 33: {
                    auditError = "Value for a Side Trip not defined ";
                    view.setFatalError(true);
                    break;
                }
                case 34: {
                    auditError = "Value for the last Fare Component not defined ";
                    view.setFatalError(true);
                    break;
                }
                case 35: {
                    auditError = "Value for the last Side Trip not defined ";
                    view.setFatalError(true);
                    break;
                }
                case 36: {
                    auditError = "Amount Mismatch in Total Nuc and Fare ";
                    view.setFatalError(true);
                    break;
                }
                case 37: {
                    auditError = "Error in Fare Calculation ";
                    view.setFatalError(true);
                    break;
                }
                case 38: {
                    auditError = "Memory Exhausted ";
                    view.setFatalError(true);
                    break;
                }
                case 39: {
                    auditError = "String Heap Block Memory Exhausted ";
                    view.setFatalError(true);
                    break;
                }
                case 40: {
                    auditError = "No Fare on Coupon Audit ";
                    view.setFatalError(true);
                    break;
                }
                case 41: {
                    auditError = "Empty Fare Component ";
                    view.setFatalError(true);
                    break;
                }
                case 51: {
                    auditError = "Tax amount total not match ";
                    view.setFatalError(true);
                    break;
                }
                case 52: {
                    auditError = "Tax code is not found ";
                    view.setFatalError(true);
                    break;
                }
                case 62: {
                    auditError = "OS error ";
                    view.setFatalError(true);
                    break;
                }
                case 63: {
                    auditError = "database error ";
                    view.setFatalError(true);
                    break;
                }
                case 65: {
                    auditError = "cannot get AirwayId of the ticket ";
                    view.setFatalError(true);
                    break;
                }
                case 66: {
                    auditError = "Prorate Factor not found ";
                    view.setFatalError(true);
                    break;
                }
                case 67: {
                    auditError = "cannot get RoeRate for ";
                    view.setFatalError(true);
                    break;
                }
                case 68: 
                case 69: 
                case 70: {
                    auditError = "cannot get 5DayRate for ";
                    view.setFatalError(true);
                    break;
                }
                case 71: {
                    auditError = "cannot get CountryName for ";
                    view.setFatalError(true);
                    break;
                }
                case 72: {
                    auditError = "cannot get AreaName for ";
                    view.setFatalError(true);
                    break;
                }
                case 73: {
                    auditError = "cannot get FixedFare for ";
                    view.setFatalError(true);
                }
            }
            auditError = auditError + audit.getErrorString();
            errorString = errorString + auditError;
            view.setErrorString(errorString);
        }
        return view;
    }

    AuditView createErrorView(String ticketNumber, ProrateAudit audit) {
        AuditView view = new AuditView();
        String couponNumber = null;
        if (ticketNumber.length() > 13) {
            couponNumber = ticketNumber.substring(13);
            ticketNumber = ticketNumber.substring(0, 13);
        }
        view.setTicketNumber(ticketNumber);
        view.setCouponNumber(couponNumber);
        if (audit == null) {
            return view;
        }
        view.setAirwayNumber(audit.getAirwayNumber());
        view.setInwardNumber(audit.getInwardNumber());
        view.setEndorsement(audit.getEndorsement());
        view.setIssueDate(audit.getIssueDate());
        view.setIssuePlace(audit.getIssuePlace());
        view.setInvoiceMonth(audit.getInvoiceMonth());
        view.setOrigin(audit.getOrigin());
        view.setDestination(audit.getDestination());
        view.setCurrency(audit.getCurrency());
        view.setSalesCurrency(audit.getSalesCurrency());
        view.setFareCalculation(audit.getFareCalculation());
        view.setTicketFare(Double.toString(audit.getTicketFare()));
        view.setSalesFare(Double.toString(audit.getSalesFare()));
        view.setTotalNuc(Double.toString(audit.getTotalNuc()));
        view.setLessAmt(Double.toString(audit.getLessAmt()));
        view.setStopOverCharge(Double.toString(audit.getStopOverCharge()));
        view.setErrorFlag(Integer.toString(audit.getErrorFlag()));
        view.setErrorString(audit.getErrorString());
        if (audit.getSectors() == null || audit.getSectors().length <= 0) {
            return view;
        }
        if (audit.getSectors() != null && audit.getSectors().length > 0) {
            for (int i = 0; i < audit.getSectors().length; ++i) {
                ProrateSector sector = audit.getSectors()[i];
                view.setStopOver(i, sector.getStopOver() == 0 ? " " : "X/");
                view.setDepCode(i, sector.getDepCode());
                view.setDestCode(i, sector.getDestCode());
                if (sector.getFareBasisFullStr() != null && sector.getFareBasisFullStr().length() > 0) {
                    view.setFareBasis(i, sector.getFareBasisFullStr());
                } else {
                    view.setFareBasis(i, sector.getFareBasis());
                }
                view.setCarrier(i, sector.getCarrier());
                view.setClassOfService(i, sector.getClassOfService());
                view.setFareComponent(i, sector.getFareComponent() < 0.0 ? "" : Double.toString(sector.getFareComponent()));
                view.setFlightNo(i, sector.getFlightNo().equals("-1") ? "" : sector.getFlightNo());
                view.setFlightDate(i, sector.getFlightDate());
                view.setClassDiffPlus(i, Double.toString(sector.getClassDiffPlus()));
                view.setSecureCharge(i, Double.toString(sector.getSecureCharge()));
                view.setSideTripPlus(i, Double.toString(sector.getSideTripPlus()));
                view.setStopOverPlus(i, Double.toString(sector.getStopOverPlus()));
            }
        }
        if (audit.isOwnAudit() && audit.isTicketing()) {
            view.setProrateType("issued by own carrier");
        } else if (audit.isOwnAudit() && audit.isInward()) {
            view.setProrateType("inward");
        } else {
            view.setProrateType("outward");
        }
        if (audit.getTraceLevel() == 10000) {
            view.setTraceLevel("detail");
        }
        return view;
    }
}

