/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SyncMap;
import java.util.Comparator;
import java.util.SortedMap;

public class SyncSortedMap
extends SyncMap
implements SortedMap {
    public SyncSortedMap(SortedMap map, Sync sync) {
        this(map, sync, sync);
    }

    public SyncSortedMap(SortedMap map, ReadWriteLock rwl) {
        super(map, rwl.readLock(), rwl.writeLock());
    }

    public SyncSortedMap(SortedMap map, Sync readLock, Sync writeLock) {
        super(map, readLock, writeLock);
    }

    protected SortedMap baseSortedMap() {
        return (SortedMap)this.c_;
    }

    public Comparator comparator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Comparator comparator = this.baseSortedMap().comparator();
            return comparator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public Object firstKey() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object k = this.baseSortedMap().firstKey();
            return k;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public Object lastKey() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object k = this.baseSortedMap().lastKey();
            return k;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public SortedMap subMap(Object fromElement, Object toElement) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncSortedMap syncSortedMap = new SyncSortedMap(this.baseSortedMap().subMap(fromElement, toElement), this.rd_, this.wr_);
            return syncSortedMap;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public SortedMap headMap(Object toElement) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncSortedMap syncSortedMap = new SyncSortedMap(this.baseSortedMap().headMap(toElement), this.rd_, this.wr_);
            return syncSortedMap;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public SortedMap tailMap(Object fromElement) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncSortedMap syncSortedMap = new SyncSortedMap(this.baseSortedMap().tailMap(fromElement), this.rd_, this.wr_);
            return syncSortedMap;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }
}

