/*
 * Decompiled with CFR 0.152.
 */
import jp.sourceforge.gnp.audit.ejb.client.AuditEjbClient;
import jp.sourceforge.gnp.audit.ejb.interfaces.AuditEjb;

class AuditClientFileEjb
extends ProrateTestFile {
    AuditEjb ejb = null;

    AuditClientFileEjb() {
    }

    AuditClientFileEjb(String filename) throws Exception {
        super(filename);
        this.ejb = AuditEjbClient.makeInstance();
    }

    public static void main(String[] args) {
        AuditClientFileEjb client = null;
        String command = null;
        try {
            client = args.length > 0 ? new AuditClientFileEjb(args[0]) : new AuditClientFileEjb("test_ticket");
            command = args.length > 1 ? args[1] : "prorate";
        }
        catch (Exception e) {
            System.err.println("error in creating AuditClientFileEjb() : " + e.getMessage());
        }
        if (client == null) {
            return;
        }
        client.inputAudit();
        if (client.ticketCoupon >= 0) {
            client.ticketNumber = client.ticketNumber + client.ticketCoupon;
        }
        client.audit.setAirwayNumber(client.ticketNumber.substring(0, 3));
        client.printAudit();
        AuditEjb ejb = null;
        try {
            ejb = client.ejb;
        }
        catch (Exception e) {
            String errorString = e.getMessage();
            if (errorString == null) {
                errorString = e.toString();
            }
            StackTraceElement[] traces = e.getStackTrace();
            for (int i = 0; i < traces.length; ++i) {
                errorString = errorString + "\n" + traces[i].toString();
            }
            client.audit.setErrorString(errorString);
            if (client.audit != null) {
                client.printAudit();
            }
            return;
        }
        if (command.equals("persist")) {
            boolean ret = false;
            try {
                ret = ejb.persist(client.ticketNumber, client.audit);
            }
            catch (Exception e) {
                String errorString = e.getMessage();
                if (errorString == null) {
                    errorString = e.toString();
                }
                StackTraceElement[] traces = e.getStackTrace();
                for (int i = 0; i < traces.length; ++i) {
                    errorString = errorString + "\n" + traces[i].toString();
                }
                System.out.println(errorString);
            }
            if (!ret) {
                System.out.println("persist(" + client.ticketNumber + ") returned false");
            } else {
                client.printAudit();
            }
        } else if (command.equals("prorate")) {
            try {
                client.audit = ejb.prorate(client.ticketNumber, client.audit);
            }
            catch (Exception e) {
                String errorString = e.getMessage();
                if (errorString == null) {
                    errorString = e.toString();
                }
                StackTraceElement[] traces = e.getStackTrace();
                for (int i = 0; i < traces.length; ++i) {
                    errorString = errorString + "\n" + traces[i].toString();
                }
                client.audit.setErrorString(errorString);
            }
            if (client.audit == null) {
                System.out.println("prorate(" + client.ticketNumber + ") returned null");
            } else {
                client.printAudit();
            }
        } else {
            System.out.println("command [" + command + "] not supported");
        }
    }
}

