/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifdef VA2
#include	<varargs.h>
#else
#include	<stdarg.h>
#endif
#include	"xl.h"

XL_SEXP *
list(XL_SEXP * a,...)
{
va_list p;
XL_SEXP * s;
	a = cons(a,0);
#ifdef VA2
	va_start(p);
#else
	va_start(p,a);
#endif
	for ( ; ; ) {
		s = va_arg(p,XL_SEXP*);
		if ( s == 0 )
			break;
		a = append(a,cons(s,0));
	}
	va_end(p);
	return a;
}

XL_SEXP * nonlock_append(XL_SEXP * a,XL_SEXP * b);

XL_SEXP *
List(XL_SEXP * a,...)
{
va_list p;
XL_SEXP * s;
int _s;
	a = cons(a,0);
#ifdef VA2
	va_start(p);
#else
	va_start(p,a);
#endif
	for ( ; ; ) {
		_s = va_arg(p,int);
		if ( _s == -1 )
			break;
		s = (XL_SEXP *)_s;
		a = append(a,cons(s,0));
	}
	va_end(p);
	return a;
}

