/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_List();

void
init_List(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"List"),
		get_func_prim(xl_List,FO_APPLICATIVE,0,1,-1));
}

XL_SEXP *
xl_List(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * ss, * ret1,* ret2;

	ret1 = 0;
	for ( ss = cdr(s) ; get_type(ss) ; ss = cdr(ss) ) {
		ret1 = cons(car(ss),ret1);
	}
	ret2 = 0;
	for ( ; get_type(ret1) ; ret1 = cdr(ret1) ) {
		ret2 = cons(car(ret1),ret2);
	}
	return ret2;
}

