/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

/*
#define DONT_USE_LOCK
*/
#include	<stdlib.h>
#include	"memory_debug.h"
#include	"lock_level.h"
#include	"save_global.h"

#ifndef DONT_USE_LOCK
#include	"task.h"
#endif

#define PREAMBLE_32	0x12345678

/*
void *
d_alloc(int size,int type)
{
char * ret;
int i;
	ret = malloc(size);
	for ( i = 0; i < size ;i ++ )
		ret[i] = 0x79;
	return (void*)ret;
}
*/

#ifdef MEMORY_DEBUG

#define ALIGN	4

int flag;

#ifndef DONT_USE_LOCK
SEM md_lock;
#endif

#ifdef DONT_USE_LOCK
#define LOCK	{}
#define UNLOCK	{}
#define NEW_LOCK {}
#endif

#ifndef DONT_USE_LOCK
#define LOCK	if ( md_lock ) lock_task(md_lock);
#define UNLOCK	if ( md_lock ) unlock_task(md_lock,"unlock");
#define NEW_LOCK	md_lock = new_lock(LL_MD);
#endif

char * last_free_file[256];
int last_free_line[256];
unsigned char last_free_ptr;

void
init_type_msg()
{
	if ( flag )
		return;
	flag = 1;
	NEW_LOCK;
}

void
init_d_alloc()
{

	SG_TITLE;
	sg("char**",		"last_free_file",	&last_free_file);
	sg("int*",		"last_free_line",	&last_free_line);
	sg("unsigned char",	"last_free_ptr",	&last_free_ptr);
}


void
set_pre(void * ptr,int pre)
{
char * p;
	p = ptr;
	p[0] = (pre>>24) & 0x0ff;
	p[1] = (pre>>16) & 0x0ff;
	p[2] = (pre>>8) & 0x0ff;
	p[3] = pre & 0x0ff;
}

void * d_alloc(int size,int type)
{
int * ret;
char * ptr;
int pre;
	init_type_msg();
	LOCK;
	pre = time(0) + PREAMBLE_32;
	ret = malloc(size+sizeof(int)*(ALIGN+1));
	if ( type > MT_MAX )
		type = 0;
	set_pre(&ret[0],pre);
	ret[1] = size;

	ptr = (char*)(ret+ALIGN);
	set_pre(&ptr[size],pre);

	UNLOCK;
	return (void*)(ret+ALIGN);
}



void * d_calloc(int size,int el,int no)
{
char * ret;
int i;
	ret = d_alloc(size*el,no);
	if ( ret == 0 )
		return 0;
	for ( i = 0 ; i < size*el ; i ++ )
		ret[i] = 0;
	return ret;
}

void * d_re_alloc(void * ptr,int size)
{
int * ret;
int type,old_size;
char * pp, * qq;
	LOCK;
	if ( ptr == 0 ) {
		UNLOCK;
		return d_alloc(size,0); 
	}
	ret = (int*)ptr;
	ret = ret - ALIGN;
	type = ret[0];
	old_size = ret[1];
	ret = realloc(ret,size+sizeof(int)*(ALIGN+1));
	ret[0] = type;
	ret[1] = size;
	pp = (char*)&ret[ALIGN];
	qq = (char*)&ret[0];
	pp[size] = qq[0];
	pp[size+1] = qq[1];
	pp[size+2] = qq[2];
	pp[size+3] = qq[3];
	UNLOCK;
	return (void*)(ret+ALIGN);
}

void xx_d_f_ree(void * ptr,char * file,int line)
{
int * ret;
int size;
int i;
char * p;
unsigned char * pp, * qq;
	LOCK;

	ret = ptr;
	ret = ret - ALIGN;

	qq = (char*)&ret[0];
	size = ret[1];
	pp = (char*)&ret[ALIGN];
	if ( pp[size] != qq[0] )
		er_panic("xx_d_f_ree(1)");
	if ( pp[size+1] != qq[1] )
		er_panic("xx_d_f_ree(1)");
	if ( pp[size+2] != qq[2] )
		er_panic("xx_d_f_ree(1)");
	if ( pp[size+3] != qq[3] )
		er_panic("xx_d_f_ree(1)");
	ret[0] = (int)file;
	ret[1] = line;
	ret[2] = (int)file;
	ret[3] = line;
	for ( p = ptr, i = size ; i > 0 ; i -- )
		*p++ = last_free_ptr;
	free(ret);

	last_free_ptr ++;

	UNLOCK;
}

void
change_memtype(void * ptr,int type)
{
int * ret;
int old_type;
int size;
/*
	LOCK;
	ret = ptr;
	ret = ret - ALIGN;
	old_type = ret[0];
	size = ret[1];
	ret[0] = type;
	memory_type[old_type] --;
	memory_size[old_type] -= size;
	memory_type[type] ++;
	memory_size[type] += size;
	UNLOCK;
*/
}


void
indicate_md()
{
int i;
int fg;
/*	printf("----\n");
	fg = 0;
	for ( i = 0 ; i < MT_MAX ; i ++ ) {
		if ( memory_type[i] == 0 )
			continue;
		if ( type_msg[i] )
			printf("(%s - %i) ",type_msg[i],memory_type[i]);
		else	printf("(%i - %i) ",i,memory_type[i]);
		fg = 1;
	}
	if ( fg )
		printf("\n");
*/
}



void
indicate_md_by_large()
{
int i;
int fg;
int max;
int cur_max;
/*	printf("----\n");
	fg = 0;
	max = 0x7fffffff;
	for ( ; max ; ) {
		cur_max = 0;
		for ( i = 0 ; i < MT_MAX ; i ++ ) {
			if ( memory_type[i] == 0 )
				continue;
			if ( memory_type[i] >= max ) 
				continue;
			if ( cur_max < memory_type[i] )
				cur_max = memory_type[i];
		}
		for ( i = 0 ; i < MT_MAX ; i ++ ) {
			if ( memory_type[i] == 0 )
				continue;
			if ( memory_type[i] != cur_max )
				continue;
			if ( type_msg[i] )
				printf("(%s - %i) ",
					type_msg[i],memory_type[i]);
			else	printf("(%i - %i) ",i,memory_type[i]);
			fg = 1;
		}
		max = cur_max;
	}
	if ( fg )
		printf("\n");
*/
}


void
indicate_md_in_buf(char ** ptr,int * cnt,int * size)
{
int i;
int fg;
/*	fg = 0;
	for ( i = 0 ; i < MT_MAX ; i ++ ) {
		if ( memory_type[i] == 0 ) {
			ptr[i] = 0;
			cnt[i] = 0;
			size[i] = 0;
			continue;
		}
		if ( type_msg[i] ) {
			ptr[i] = d_alloc(100,12);
			sprintf(ptr[i],"%s",
				type_msg[i],memory_type[i]);
			cnt[i] = memory_type[i];
			size[i] = memory_size[i];
		}
		else {
			ptr[i] = d_alloc(30,13);
			sprintf(ptr[i],"%i",i,memory_type[i]);
			cnt[i] = memory_type[i];
			size[i] = memory_size[i];
		}
		fg = 1;
		
	}
*/
}


#endif


#ifndef MEMORY_DEBUG

void
indicate_md_in_buf(char ** ptr,int * cnt,int * size)
{
int i;
int fg;
	fg = 0;
	for ( i = 0 ; i < MT_MAX ; i ++ ) {
		ptr[i] = 0;
		cnt[i] = 0;
		size[i] = 0;
	}
}

#endif


void
free_indicate_md_buf(char ** ptr)
{
int i;
	for ( i = 0 ; i < MT_MAX ; i ++ ) {
		if ( ptr[i] == 0 )
			continue;
		d_f_ree(ptr[i]);
		ptr[i] = 0;
	}
}


