/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"gbacrp.h"

XL_SEXP * gb_MPTrigger();

void
init_gb_MPTrigger(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"MPTrigger"),
		get_func_prim(gb_MPTrigger,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
gb_MPTrigger(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
int ses;
URL u;
XL_SEXP * ret;
	get_url2(&u,l_string(std_cm,"xlp://localhost:9100/"),1218);
	u.port = get_mp_port();
	if ( u.port == 0 ) {
		ret = 0;
		goto end;
	}

	ses = open_session(SEST_OPTIMIZE);
	ret = remote_session(
		gblisp_top_env0,
		ses,
		&u,
		l_string(std_cm,"gbmp"),
		l_string(std_cm,"user"),
		l_string(std_cm,"Get"),
		List(s,-1),
		0,0,0);
	if ( get_type(ret) == XLT_ERROR ) {
		if ( ret->err.code == XLE_PROTO_ACCESS_STREAM ) {
			ret = get_error(
				s->h.file,
				s->h.line,
				XLE_SYSTEM_INTERNAL,
				l_string(std_cm,"MProuting"),
				n_get_string("server is down"));
			
		}
	}
	close_session(ses);
end:
	free_url(&u);
	return ret;
}

