/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	"xl.h"
#include	"xlerror.h"


XL_SEXP *
cdr(XL_SEXP * s)
{
	switch ( get_type(s) ) {
	case XLT_ERROR:
		return s;
	case XLT_PAIR:
		return s->pair.cdr;
	default:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"cdr"),
			list(get_string(
				l_string(std_cm,"typemismatch in parameter")),
				0));
	}
}

XL_SEXP *
gb_cdr(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * ret;
	ret = get_el(s,1);
	switch ( get_type(ret) ) {
	case XLT_ERROR:
		return ret;
	case XLT_PAIR:
		return ret->pair.cdr;
	default:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"cdr"),
			list(get_string(
				l_string(std_cm,"typemismatch in parameter")),
				0));
	}
}

