/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"gbgraph.h"

XL_SEXP * xl_InsertRect();

void
init_InsertRect(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"InsertRect"),
		get_func_prim(xl_InsertRect,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_InsertRect(XLISP_ENV * env,XL_SEXP * s)
{
GB_RECT rect;
GB_POINT p;
L_CHAR * base_unit;
COORDINATE_UNIT cu, * cup;
XL_SEXP * ret;
	base_unit = get_base_unit(get_el(s,1));
	zero_c_unit(&cu);
	if ( base_unit ) {
		cu.unit = base_unit;
		cu.uenv = get_uenv(env);
		cup = &cu;
	}
	else	cup = 0;
	if ( get_minrect(cup,&rect,get_el(s,1)) < 0 )
		goto type_missmatch;
	if ( get_gbpoint(cup,&p,get_el(s,2)) < 0 )
		goto type_missmatch;
	insert_rect(&rect,p);
	ret = List(
		List(	get_floating(rect.tl.x,base_unit),
			get_floating(rect.tl.y,base_unit),
			-1),
		List(	get_floating(rect.br.x,base_unit),
			get_floating(rect.br.y,base_unit),
			-1),
		-1);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"InsertRect"),
		n_get_string("type missmatch"));
}

