/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___XLoHTTP_H___
#define ___XLoHTTP_H___

#include	"server.h"
#include	"xl.h"

#define METHOD_LEN	10


typedef struct HTTP_info {
	short		http_ver;
	short		http_rev;
	int		err;
	char *		method;
	char *		dir;
	int		content_length;
	int		flags;
#define XoHINF_F_KEEP_ALIVE	0x00000001
#define XoHINF_F_CHUNKED	0x00000002
} HTTP_INFO;


typedef struct XLoHTTP_header {
	unsigned char		type;
#define XoH_T_OPEN		1
#define XoH_T_DATA		2
#define XoH_T_LAST		3
#define XoH_T_ERROR		4
#define XoH_T_KEEP_ALIVE	5
	unsigned char		sum;
	short			seq;
	unsigned int		cockie[2];
} XLoHTTP_HEADER;

int scan_HTTP(HTTP_INFO * info,STREAM * con,int flag);
void free_HTTP_info(HTTP_INFO *);
int new_accept(STREAM **,ACCESS_KEY *,XL_INTERPRETER *,PERMISSION_LIST *);
int XoH_checksum(XLoHTTP_HEADER * h);

#endif

