/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "gbview.h"
#include "xlerror.h"

XL_SEXP * xl_gv_flame_event_default();
char gv_flame_dirty_flag = 0;
extern char gv_flame_initial_done;

void
call_gv_flame_event(int type,void * w)
{
static XL_INTERPRETER * xli;
XL_SEXP * ret;

	if ( xli == 0 ) {
		xli = new_xl_interpreter();
		xli->a_type = XLA_SELF;
		setup_i(xli);
	}

	gc_push(0,0,"call_gv_flame_event");
	switch ( type ) {
	case ET_REDRAW:
		if ( gv_flame_dirty_flag )
			ret = 0;
		else {
			gv_flame_dirty_flag = 1;
			ret = eval(gblisp_top_env0,List(n_get_symbol("gv-flame-event"),
 							get_integer(type,0),0,-1));
 		}
		break;
	case ET_CLICK:
		ret = eval(gblisp_top_env0,List(n_get_symbol("gv-flame-event"),
 							get_integer(type,0),
 							List(n_get_symbol("quote"),gbp2list(w,0),-1),
 							-1));
		break;
	case ET_INFO:
		ret = eval(gblisp_top_env0,List(n_get_symbol("gv-flame-event"),
 							get_integer(type,0),
  							List(n_get_symbol("quote"),gvstatus2list(w),-1),
 							-1));
		break;
	default:
		er_panic("interface_event_func(1)");
	}
	if ( get_type(ret) == XLT_ERROR ) {
		fflush(stdout);
		s_printf(s_stdout,"EVENT error response -> ");
		print_sexp(s_stdout,ret,0);
		s_printf(s_stdout,"\n");
	}
	gc_pop(0,0);
}

void
event_loop()
{
VDISPLAY *d;
GBVIEW_STATUS sts;
VERROR err;
	if ( ! gv_flame_initial_done )
		sleep_task((int)&gv_flame_initial_done,0);
	sts.event = call_gv_flame_event;
	sts.display = d = v_open_disp(&err);
	sts.flags = SF_DISPLAY + SF_EVENT;
	wf_set_status(&sts);
	
	v_loop(d);
}

void
init_gv_flame_event(XLISP_ENV * env)
{
/*
	set_env(env, l_string(std_cm,"gv-flame-event"),
			get_func_prim(xl_gv_flame_event_default,FO_APPLICATIVE,0,3,3));
*/
}

XL_SEXP *
xl_gv_flame_event_default(
		XLISP_ENV * e,
		XL_SEXP * s)
{
	fflush(stdout);
	s_printf(s_stdout,"EVENT ");
	print_sexp(s_stdout,s,0);
	s_printf(s_stdout,"\n");
	return 0;
}
