/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"gbacrp.h"
#include	"gbmp.h"

#include "task.h"

XL_SEXP * gb_MPTrigger();


SEM debug_lock;

void
init_MPTrigger(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"MPTrigger"),
		get_func_prim(gb_MPTrigger,FO_APPLICATIVE,0,2,2));


debug_lock = new_lock(910);
}



XL_SEXP *
gb_MPTrigger(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV* a,XL_SYM_FIELD * sf)
{
XL_SEXP * f;
int len;
int mode;
int ses;


set_cpu_msg(700000);
	mode = 0;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"mode")) == 0 ) {
			if ( l_strcmp(sf->data,l_string(std_cm,"delete"))
					== 0 )
				mode = 3;
			else if ( l_strcmp(sf->data,l_string(std_cm,"lump"))
					== 0 )
				mode = 4;
			else if ( l_strcmp(sf->data,l_string(std_cm,"force"))
					== 0 )
				mode = 1;
		}
	}
	f = get_el(s,1);
	if ( get_type(f) != XLT_STRING )
		goto type_missmatch;
	len = l_strlen(f->string.data);
	if ( l_strcmp(&f->string.data[len-4],l_string(std_cm,".crd")) == 0 ) {
		if ( mode == 4 )
			insert_tick_que(0,f->string.data,TQT_LMP,
						TQL_NORMAL);
		else	insert_tick_que(0,f->string.data,TQT_CRD,
						TQL_ACRP);
	}
	else if ( l_strcmp(&f->string.data[len-4],
				l_string(std_cm,".map")) == 0 ) {
		if ( mode == 3 ) {
			insert_tick_que(0,f->string.data,TQT_DMAP,
						TQL_NORMAL);
		}
		else if ( mode == 1 ) {
			insert_tick_que(0,f->string.data,TQT_FMAP,
						TQL_NORMAL);

		}
		else	insert_tick_que(1,f->string.data,TQT_TMP,
						TQL_NORMAL);
	}

set_cpu_msg(0);
	return 0;
type_missmatch:

set_cpu_msg(0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MPTrigger"),
		n_get_string("type missmatch"));
}

