/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<sys/wait.h>
#include	<sys/time.h>
#include	<sys/types.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<signal.h>
#include	"init.h"
#include	"task.h"

void sigalarm_handler();
void sigpipe_handler();
void sigint_handler();
void siglwp_handler();

extern int task_flags;
int pri_table[PRI_MAX] = {0,10,20,30,40,50};




void
set_ignore_chld()
{
	sigignore(SIGCHLD);
}

void
set_alarm_mask(int flags)
{
	all_signal_mask(1,45);
	signal(SIGALRM,sigalarm_handler);
	signal(SIGPIPE,sigpipe_handler);
	signal(SIGLWP,siglwp_handler);
	signal(SIGINT,sigint_handler);
	task_flags = flags;
	if ( (flags&INI_THREAD) == INI_DONTWAITCHI )
		set_ignore_chld();
}


#ifndef DEADLOCK_CHECK
SEM
new_lock(int level)
{
SEM s;
	s = new_block();
	sem_init(&s->ss,0,1);
	sem_trywait(&s->ss);
	sem_post(&s->ss);
	return s;
}
#endif
#ifdef DEADLOCK_CHECK

extern SEM sem_list;

SEM
new_lock(int level)
{
SEM s, * sp;
	s = new_block();
	s->level = level;
	s->tid = 0;
	sem_init(&s->s,0,1);
	sem_trywait(&s->s);
	sem_post(&s->s);
	for ( sp = &sem_list ; *sp ; sp = &(*sp)->next )
		if ( (*sp)->level > level ) {
			s->next = *sp;
			*sp = s;
			goto ok;
		}
	s->next = 0;
	*sp = s;
ok:
	return s;
}

#endif

#ifndef DEADLOCK_CHECK
void close_lock(SEM s)
{
	sem_destroy(&s->ss);
	free_block(s);
}

int
_sem_getvalue(SEM s,int * value)
{
	return sem_getvalue(&s->ss,value);
}



#endif

#ifdef DEADLOCK_CHECK
void close_lock(SEM s)
{
SEM * sp;
	for ( sp = &sem_list ; *sp ; sp = &(*sp)->next )
		if ( *sp == s ) {
			*sp = s->next;
			break;
		}
	sem_destroy(&s->s);
	free_block(s);
}

int
_sem_getvalue(SEM s,int * value)
{
	return sem_getvalue(&s->s,value);
}



#endif

