/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"memory_debug.h"
#include	"utils.h"
#include	"xl.h"
#include	"xl_server.h"

AGENT *		agent_head,* agent_tail;

void
gc_agent()
{
AGENT * ag;
	for ( ag = agent_head ; ag ; ag = ag->next ) {
		gc_gblisp_env(ag->env);
		gc_gb_sexp(ag->func);
	}
}

int
insert_agent(
	L_CHAR * group,
	L_CHAR * agent,
	L_CHAR * ltype,
	int flags,
	XLISP_ENV * env,
	XL_SEXP * func)
{
AGENT * al;
	for ( al = agent_head ; al ; al = al->next )
		if ( l_strcmp(al->name,agent) == 0 &&
			l_strcmp(al->login_type,ltype) == 0 ) {

			al->flags = flags;
			al->env = env;
			al->func = func;
			al->group = ll_copy_str(group,1454);
			return 0;
		}
	al = d_alloc(sizeof(*al),180);
	al->name = ll_copy_str(agent,1453);
	al->login_type = ll_copy_str(ltype,1452);
	al->flags = flags;
	al->next = 0;
	al->env = env;
	al->func = func;
	al->group = ll_copy_str(group,1451);
	if ( agent_head == 0 )
		agent_head = agent_tail = al;
	else {
		agent_tail->next = al;
		agent_tail = al;
	}
	return 0;
}

AGENT *
search_agent(L_CHAR * agent,L_CHAR * ltype)
{
AGENT *al;

	for ( al = agent_head ; al ; al = al->next ) {
		if ( (l_strcmp(al->name,agent) == 0 ||
			l_strcmp(al->name,l_string(std_cm,"*")) == 0 ) &&
			(l_strcmp(al->login_type,ltype) == 0 ||
			l_strcmp(al->login_type,l_string(std_cm,"*")) == 0 ) )
			return al;
	}
	return 0;
}

