/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"unit.h"




XL_SEXP *
sub_int(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
int _i1,_i2;
DIMENSION d1[DIM],d2[DIM],dest[DIM];
int ret;
int i;
int er;
	name2dim(get_uenv(env),d1,s1->integer.unit);
	name2dim(get_uenv(env),d2,s2->integer.unit);
	if ( dim_power_cmp(d1,d2) )
		return get_integer(
			s1->integer.data - s2->integer.data,
			0);
	fit_dimension_integer(dest,d1,d2);
	_i1 = conv_unit_integer(&er,get_uenv(env),s1->integer.data,d1,dest);
	_i2 = conv_unit_integer(&er,get_uenv(env),s2->integer.data,d2,dest);
	ret = _i1 - _i2;
	normalize_dim_integer(get_uenv(env),dest,&ret);
	return get_integer(ret,dim2name(get_uenv(env),dest));
}

XL_SEXP *
sub_float(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
double _i1,_i2;
DIMENSION d1[DIM],d2[DIM],dest[DIM];
double ret;
int er;

	name2dim(get_uenv(env),d1,s1->floating.unit);
	name2dim(get_uenv(env),d2,s2->floating.unit);
	if ( dim_power_cmp(d1,d2) )
		return get_floating(
			s1->floating.data - s2->floating.data,
			0);
	fit_dimension_floating(dest,d1,d2);
	_i1 = conv_unit_floating(&er,get_uenv(env),s1->floating.data,d1,dest);
	_i2 = conv_unit_floating(&er,get_uenv(env),s2->floating.data,d2,dest);
	ret = _i1 - _i2;
	normalize_dim_floating(get_uenv(env),dest,&ret);
	return get_floating(ret,dim2name(get_uenv(env),dest));
}

XL_SEXP *
gb_sub(XLISP_ENV * e,XL_SEXP * s)
{
extern BINARY_TABLE sub_t[XLT_MAX][XLT_MAX];
XL_SEXP * ss;
	if ( list_length(s) == 3 ) 
		return binary(
			sub_t,
			e,
			get_el(s,1),
			get_el(s,2));
	ss = get_el(s,1);
	switch ( get_type(ss) ) {
	case XLT_INTEGER:
		return get_integer(-ss->integer.data,ss->integer.unit);
	case XLT_FLOAT:
		return get_floating(-ss->floating.data,ss->floating.unit);
	}
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"sub(-)"),
		n_get_string("type missmatch"));
}
