/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"u_math.h"
#include	"ex_matrix.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"associate.h"

XL_SEXP * xl_tan();

void
init_tan(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"tan"),
		get_func_prim(xl_tan,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_tan(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * d;
double dd;
L_CHAR * unit;
	unit = get_sf_attribute(sf,l_string(std_cm,"unit"));
	d = get_el(s,1);
	switch ( get_type(d) ) {
	case XLT_INTEGER:
		dd = d->integer.data;
		if ( unit == 0 )
			unit = d->integer.unit;
		break;
	case XLT_FLOAT:
		dd = d->floating.data;
		if ( unit == 0 )
			unit = d->floating.unit;
		break;
	default:
		goto type_missmatch;
	}
	if ( unit && l_strcmp(unit,l_string(std_cm,"degree")) == 0 )
		dd = dd * M_PI/180;
	return get_floating(tan(dd),0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"tan"),
		n_get_string("type missmatch"));
}

