/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl2pdb_p.h"

extern AVT_NODE * pdb_same_name_avt;
extern PDB_POLYGON2D * pdb_p_list;
CODE_INDEX * code_index;
unsigned int code_max;

typedef struct numbering_work {
	unsigned int 	code;
} NUMBERING_WORK;

int
numbering_func(AVT_NODE * a,NUMBERING_WORK * w)
{
PDB_POLYGON2D * p;
unsigned int code;
	code = w->code;
	p = a->data;
	for ( ; p ; p = p->samename ) {
		p->code = code;
		code ++;
	}
	w->code += NO_PITCH;
	return 0;
}

void
numbering()
{
NUMBERING_WORK w;
PDB_POLYGON2D * p;
unsigned int i;
	w.code = NO_PITCH;
	avt_trace_from_small(pdb_same_name_avt,numbering_func,&w);
	for ( p = pdb_p_list ; p ; p = p->next )
		if ( p->code == 0 )
			er_panic("numbering(1)");
	code_max = w.code/NO_PITCH;
	code_index = d_alloc(sizeof(CODE_INDEX)*code_max,346);
	for ( i = 0 ; i < code_max ; i ++ ){
		code_index[i].fofs = -1;
		code_index[i].minrect.tl.x = code_index[i].minrect.tl.y = 0;
		code_index[i].minrect.br.x = code_index[i].minrect.br.y = -1;
	}
	printf("\tmax id %i\n",code_max);
}
