/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef SVGTYPES_H____
#define SVGTYPES_H____

#include	"long_char.h"

typedef unsigned long SVG_COLOR_REF;
typedef unsigned char SVG_BYTE;
typedef float SVG_FLOAT;

typedef struct svg_color{
	SVG_BYTE r;
	SVG_BYTE g;
	SVG_BYTE b;
	SVG_BYTE a;
}SVG_COLOR;

typedef struct svg_point{
	SVG_FLOAT x;
	SVG_FLOAT y;
}SVG_POINT;

typedef struct svg_rect{
	SVG_FLOAT l;
	SVG_FLOAT t;
	SVG_FLOAT r;
	SVG_FLOAT b;
}SVG_RECT;

typedef struct svg_style{
	struct svg_style *next;
	L_CHAR *name;
	L_CHAR *value;
}SVG_STYLE;

typedef struct svg_path_data{
	L_CHAR *d;
	L_CHAR *id;
	SVG_STYLE *style;
}SVG_PATH_DATA;


typedef struct svg_transform_info{
	struct svg_transform_info *next;
	SVG_FLOAT x_translate;
	SVG_FLOAT y_translate;
	SVG_FLOAT x_scale;
	SVG_FLOAT y_scale;
	
	/* not supported ...*/
	SVG_FLOAT rotate_angle;
	SVG_FLOAT rotate_cx;
	SVG_FLOAT rotate_cy;
	SVG_FLOAT x_skew;
	SVG_FLOAT y_skew;
}SVG_TRANSFORM_INFO;

typedef struct svg_layer{
	struct svg_layer *parent;
	struct svg_layer **children; /* pointer array */
	int child_count;
	L_CHAR * id;
	SVG_STYLE *styles;
	SVG_TRANSFORM_INFO *transform;

/* private: */
int child_buff_size;
}SVG_LAYER;


#endif
