/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___TREE_CACHE_H___
#define ___TREE_CACHE_H___

#include	"gbparam.h"

typedef struct tree_node {
	int			flags;
#define TNF_ERROR		0x00000001
	int			level;
	int			ofs_x;
	int			ofs_y;
	int			w;
	int			h;
	unsigned long *		pixels;
	struct tree_node *	leaf[LEAF_MAX];
	struct tree_node *	parent;
	int			access;
	short			lock;
} TREE_NODE;

typedef struct tree_cache {
	TREE_NODE *		rt;
	int			rt_level;
	int			rect_logsize;
	int			(*get_pixels)();
	int			(*get_query)();
	union resource *	r;
	int			tl_x;
	int			tl_y;
	int			br_x;
	int			br_y;
	TREE_NODE * 		cache;
	struct tree_cache *	next;
} TREE_CACHE;

void init_tc(int ses,TREE_CACHE * tc,int level,int rs,
	int (*func_pixels)(),int (*func_query)(),
	union resource * r);
unsigned long
_tc_get_pixel(TREE_CACHE * tc,int level,int x,int y,int * lev);


#endif
