/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbgraph.h"


char day_ary[8][5] = {
	"Sun",
	"Mon",
	"Tue",
	"Wed",
	"Thu",
	"Fri",
	"Sat",
	"*"
};

void
set_format(char * buf,char d)
{
	if ( d == -1 ) {
		buf[0] = '*';
		buf[1] = 0;
	}
	else	sprintf(buf,"%i",(int)d);
}

void
gb_time_format(char * ret,GB_TIME * t)
{
char year[100];
char month[10];
char date[10];
char hour[10];
char min[10];
char sec[10];
	if ( t->year == 0 )
		sprintf(year,"*");
	else if ( t->year == (int)t->year )
		sprintf(year,"%i",(int)t->year);
	else	sprintf(year,"%f",t->year);
	set_format(month,t->month);
	set_format(date,t->date);
	set_format(hour,t->hour);
	set_format(min,t->min);
	set_format(sec,t->sec);
	if ( t->day < 0 || t->day >= 8 )
		t->day = 7;
	sprintf(ret,"%s-%s-%s.%s.%s:%s:%s",
			year,month,date,day_ary[t->day],hour,min,sec);
}