/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"machine/include.h"
#include	"memory_debug.h"
#include	"task.h"
#include	"utils.h"
#include	"server.h"


extern SEM netutils_lock;

void
init_access_permission(ACCESS_PERMISSION * ap)
{
	ap->head = ap->tail = 0;
}

void
free_access_list(ACCESS_PERMISSION * ap)
{
ACCESS_LIST * al;
	for ( ; ap->head ; ) {
		al = ap->head;
		ap->head = al->next;

		if ( al->domain )
			d_f_ree(al->domain);
		d_f_ree(al);
	}
}

void
insert_access_list(
	ACCESS_PERMISSION * ap,
	int	ip,
	int	mask,
	char *	domain,
	int	auth_type,
	int	auth_flags,
	int	type)
{
ACCESS_LIST * al;
	al = d_alloc(sizeof(*al));
	memset(al,0,sizeof(*al));
	al->ip = ip;
	al->mask = mask;
	if ( ip )
		al->domain = 0;
	else if ( domain == 0 ) {
		al->ip = 0;
		al->mask = 0;
		al->domain = 0;
	}
	else {
		al->domain = copy_str(domain);
	}
	al->type = type;

	al->next = 0;
	if ( ap->head ) {
		ap->tail->next = al;
		ap->tail = al;
	}
	else {
		ap->head = ap->tail = al;
	}
}

extern int accept_test;

int
check_permission(ACCESS_PERMISSION * ap,int ip,L_CHAR* user)
{
HOST_ENTRY * hp;
char ** q;
ACCESS_LIST * al;
int len1,len2;
int ip_addr;

	ip_addr = ip;
	hp = r_gethostbyaddr(getHA_v4(ip_addr));
	
	for ( al = ap->head ; al ; al = al->next ) {
		if ( al->ip ) {
			if ( (ip&al->mask) == al->ip ) {
				return al->type;
			}
			continue;
		}
		if ( al->domain == 0 ) {
			return al->type;
		}
		if ( hp == 0 )
			continue;
		len1 = strlen(al->domain);
		q = hp->names;
		for ( ; *q ; q ++ ) {
			len2 = strlen(*q);
			if ( len2 < len1 )
				continue;
			if ( strcmp(&(*q)[len2-len1],al->domain)
					== 0 ) {
				if ( len2 == len1 ) {
					return al->type;
				}
				if ( (*q)[len2-len1-1] == '.' ) {
					return al->type;
				}
			}
		}
	}
	return AP_DENY;
}


