/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#define STREAM_LIB

#ifdef VA2
#include	<varargs.h>
#else
#include	<stdarg.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include	"machine/err.h"
#include	"memory_debug.h"
#include	"stream.h"
#include	"task.h"
#include	"s_buf.h"
#include	"utils.h"
#include	"pri_level.h"

extern SEM stream_lock;

#define BLOCK_SIZE 1024

/* L_CHAR string memory writer */
typedef struct {
	L_CHAR *mem;
	int mem_size;
	int len;
}S_PRINTF_STREAM;


//char sp[4000];

void *
get_spsat(S_PRINTF_SAT * sat,int type,int size)
{
int old;
	if ( sat->alc_len[type] < size ) {
		sat->alc[type] = d_re_alloc(sat->alc[type],size);
		sat->alc_len[type] = size;
	}
	old = sat->alc_size[type];
	if ( old < size ) {
		memset(&sat->alc[type][old],0,size-old);
	}
	sat->alc_size[type] = size;
	return (void*)sat->alc[type];
}



static void 
put_lstr(S_PRINTF_STREAM *s, L_CHAR *lstr,S_PRINTF_SAT * sat){
	int len = l_strlen(lstr);
	int memsize_changed = 0;

	if(len == 0)
		return;

	while(s->mem_size <= (s->len + len)){
		if(s->mem_size == 0)
			s->mem_size = 256;
		else
			s->mem_size *= 2;
		memsize_changed = 1;
	}
	if(memsize_changed){
		if ( sat ) {
			s->mem = get_spsat(sat,SPSAT_MEM,s->mem_size*sizeof(L_CHAR));
		}
		else {
			if(s->mem == 0)
				s->mem = (L_CHAR*)d_alloc(
					s->mem_size*sizeof(L_CHAR));
			else
				s->mem = (L_CHAR*)d_re_alloc(
					s->mem, s->mem_size*sizeof(L_CHAR));
		}
	}
	memcpy( &(s->mem[s->len]), lstr, len*sizeof(L_CHAR));
	s->len += len;
}




int 
_s_printf_1(STREAM *s,int * erp,const char * fmt, va_list p){
	S_PRINTF_STREAM out;
	char *in_begin;
	char *in_end;
	char *temp;
	char type;
	char prefix;
	
	char single_format[64];
	char *single_format_dest;
	
	single_format_dest = malloc(10000);
	memset(&out, 0, sizeof(S_PRINTF_STREAM));


	temp = d_alloc(strlen(fmt)+1);
	
	/* begin parse */
	in_begin = (char*)fmt;

	while(*in_begin){
		in_end = in_begin;
		/* read to '%' */
		in_end = strchr(in_end, '%');
		if(in_end==NULL){
			in_end = in_begin + strlen(in_begin);
		}
		
		/* write string who has no format */
		if(in_begin != in_end){
			strncpy(temp, in_begin, in_end-in_begin);
			temp[in_end-in_begin] = '\0';
			put_lstr(&out, l_string(&utf8_cm, temp),0);
			/* end of format string */
			if(!*in_end){
				break;
			}
		}
		
		/* parse format string that is ... */
		/* [flags] [width] [precision] [{h | l | I64 | L}]type */
		in_begin = in_end;
		++in_end;
		
		prefix = ' ';

		/* flags */
		if(strspn(in_end, "+- 0#") != 0)
			++in_end;
		/* width */
		in_end += strspn(in_end, "0123456789*");
		/* precision */
		if(*in_end == '.')
			in_end+=2;
		/* prefix */
		if(!strncmp(in_end, "I64", 3)){
			prefix = 'L';
			in_end += 3;
		}
		else if(!strncmp(in_end, "ll", 2)){
			prefix = 'L';
			in_end += 2;
		}
		else if(strspn(in_end, "hlL") != 0){
			prefix = *in_end;
			++in_end;
		}
		/* type */
		type = *in_end++;
		
		/* copy single format string */
		strncpy(single_format, in_begin, in_end-in_begin);
		single_format[in_end-in_begin] = '\0';
		
		/* if type is string */
		if(type == 's' || type=='S'){
			if(prefix == 'l' || prefix == 'L'){
				put_lstr(&out, va_arg(p,L_CHAR*),0);
			}
			else{
				/* what is arg's-char* code ?  std or s->h.cm ?? */
				/* put_lstr(&out, l_string(&utf8_cm, va_arg(p,char*))); */
				put_lstr(&out, l_string(&utf8_cm, va_arg(p,char*)),0);
			}
		}
		else{
			single_format_dest[0] = '\0';
			switch(type){
				case '%':
					sprintf(single_format_dest, "%%");
					break;
				case 'c':
				case 'C':
				case 'd':
				case 'i':
				case 'o':
				case 'u':
				case 'x':
				case 'X':
					if ( prefix == 'L' )
						sprintf(single_format_dest, single_format, 
								va_arg(p,INTEGER64));
					else	sprintf(single_format_dest, single_format, 
								va_arg(p,int));
					break;
				case 'e':
				case 'E':
				case 'f':
				case 'g':
				case 'G':
					sprintf(single_format_dest, single_format, va_arg(p,double));
					break;
				case 'n':
					sprintf(single_format_dest, single_format, va_arg(p,int*));
					break;
				case 'p':
					sprintf(single_format_dest, single_format, va_arg(p,void*));
					break;
			}
			if(*single_format_dest)
				put_lstr(&out, l_string(&utf8_cm, single_format_dest),0);
		}
		
		/* update pointer */
		in_begin = in_end;
	}
	
	free(single_format_dest);
	
	if ( out.mem == 0 )
		goto end;

	out.mem[out.len] = 0;
	
	/* write lstring buffer to STREAM */
	{
		int er,ss;
		L_CHAR * str;
		CODE_METHOD * cm;
		void * work;
		char * ret,* pp;
		char ex[20];
		char * exp;
		int rbyte;
		int len,ptr;
		S_TABLE * tbl;
		S_FILE_THREAD t;

		int pri;

		pri = push_pri(PRI_NETWORK);
		lock_task(stream_lock);
		if ( s == 0 ) {
			if ( erp )
				*erp = ESYS_INVAL;
			unlock_task(stream_lock,"s_write");
			change_pri(0,pri);
			return -1;
		}
		if ( s->h.tbl == 0 ) {
			if ( erp )
				*erp = ESYS_INVAL;
			unlock_task(stream_lock,"s_write");
			change_pri(0,pri);
			return -1;
		}
		tbl = s->h.tbl;
		_s_insert_thread(s,&t);


		str = out.mem;
		cm = s->h.cm;
		work = s->h.cm_work;
		
		len = 4*out.len;
		ret = d_alloc(len+1);
		ptr = 0;
		
		for( ; *str; str++){
			if ( s->h.cr_mode &&
				(*str == '\n' || *str == '\r' || *str == C_CANCEL ) ) {
				s->h.cr_cnt ++;
			}
			if ( len-ptr < cm->max_ret ) {
				len = len+cm->max_ret;
				ret = d_re_alloc(ret,len+1);
			}
			rbyte = (*cm->to_external)((unsigned char*)&ret[ptr], work, *str);
			if ( rbyte == 0 ) {
				sprintf(ex,"&cx%x;",(int)*str);
				for ( exp = &ex[0]; *exp ; exp ++ ) {
					if ( len-ptr < cm->max_ret ) {
						len = len+cm->max_ret;
						ret = d_re_alloc(ret,
								len+1);
					}
					rbyte = (*cm->to_external)
						((unsigned char*)&ret[ptr],work,
						((L_CHAR)((*exp)&0x0ff)));
					ptr += rbyte;
				}
			}
			else {
				ptr += rbyte;
			}
		}


		if ( (tbl->flags & STF_BUF_OUT) ||
				(s->h.wb_flags & STF_BUF_OUT) ) {
			copy_in_sbuf(&s->h.write_buf,ret,ptr,SEM_NULL);
			calc_checksum(s,ret,ptr,0);
			d_f_ree(ret);
			wakeup_task((int)s_write);
			_s_delete_thread(s,&t);
			unlock_task(stream_lock,"__s_printf");
			change_pri(0,pri);
		}
		else {
			unlock_task(stream_lock,"__s_printf");
			change_pri(0,pri);


			pp = ret;
			for ( ; ptr > 0 ; ) {
				ss = ptr;
			retry:
				lock_task(stream_lock);
				if ( s->h.write_abort_type ) {
					s->h.write_tid = get_tid();
					s->h.write_in_time = get_xltime();
				}
				unlock_task(stream_lock,"s_write");

				er = (*tbl->write)(s,pp,ss);


				lock_task(stream_lock);
				s->h.write_tid = 0;
				s->h.write_in_time = 0;
				unlock_task(stream_lock,"s_write(2)");

				if ( er < 0 ) {
					if ( errno == ESYS_AGAIN ) {
						ss = ss/2;
						if ( ss <= 0 )
							ss = 1;
						goto retry;
					}
					if ( erp )
						*erp = errno;
					break;
				}
				else calc_checksum(s,pp,er,2);
				if ( er == 0 )
					break;
				pp += er;
				ptr -= er;
			}


			d_f_ree(ret);

			
			s_delete_thread(s,&t);
		}
	}

end:	

	d_f_ree(temp);
	if ( out.mem )
		d_f_ree(out.mem);
	return out.len;
}


int
flush_spsat(S_PRINTF_SAT * sat,int * erp)
/* write lstring buffer to STREAM */
{
	int er,ss;
	L_CHAR * str;
	CODE_METHOD * cm;
	void * work;
	char * ret,* pp;
	char ex[20];
	char * exp;
	int rbyte;
	int len,ptr;
	S_TABLE * tbl;
	S_FILE_THREAD t;
	
	int size;

	int pri;

	if ( sat->err < 0 ) {
		if ( erp )
			*erp = ESYS_INVAL;
		return -1;
	}

	pri = push_pri(PRI_NETWORK);
	lock_task(stream_lock);
	if ( sat->st == 0 ) {
		if ( erp )
			*erp = ESYS_INVAL;
		sat->err = -1;
		sat->str_buf_ptr = 0;
		unlock_task(stream_lock,"s_write");
		change_pri(0,pri);
		return -1;
	}
	if ( sat->st->h.tbl == 0 ) {
		if ( erp )
			*erp = ESYS_INVAL;
		sat->err = -1;
		sat->str_buf_ptr = 0;
		unlock_task(stream_lock,"s_write");
		change_pri(0,pri);
		return -1;
	}
	tbl = sat->st->h.tbl;
	_s_insert_thread(sat->st,&t);


	str = sat->str_buf;
	cm = sat->st->h.cm;
	work = sat->st->h.cm_work;
	size = sat->str_buf_ptr;
	
	len = 4*size;
	ret = get_spsat(sat,SPSAT_RET,len+1);
	ptr = 0;
	
	for( ; size ; str++, size -- ){
		if ( sat->st->h.cr_mode &&
			(*str == '\n' || *str == '\r' || *str == C_CANCEL ) ) {
			sat->st->h.cr_cnt ++;
		}
		if ( len-ptr < cm->max_ret ) {
			len = len+cm->max_ret;
			ret = get_spsat(sat,SPSAT_RET,len+1);
		}
		rbyte = (*cm->to_external)((unsigned char*)&ret[ptr], work, *str);
		if ( rbyte == 0 ) {
			sprintf(ex,"&cx%x;",(int)*str);
			for ( exp = &ex[0]; *exp ; exp ++ ) {
				if ( len-ptr < cm->max_ret ) {
					len = len+cm->max_ret;
					ret = get_spsat(sat,SPSAT_RET,
							len+1);
				}
				rbyte = (*cm->to_external)
					((unsigned char*)&ret[ptr],work,
					((L_CHAR)((*exp)&0x0ff)));
				ptr += rbyte;
			}
		}
		else {
			ptr += rbyte;
		}
	}


	if ( (tbl->flags & STF_BUF_OUT) ||
			(sat->st->h.wb_flags & STF_BUF_OUT) ) {
		copy_in_sbuf(&sat->st->h.write_buf,ret,ptr,SEM_NULL);
		calc_checksum(sat->st,ret,ptr,0);
		wakeup_task((int)s_write);
		_s_delete_thread(sat->st,&t);
		unlock_task(stream_lock,"__s_printf");
		change_pri(0,pri);
	}
	else {
		unlock_task(stream_lock,"__s_printf");
		change_pri(0,pri);


		pp = ret;
		for ( ; ptr > 0 ; ) {
			ss = ptr;
		retry:
			lock_task(stream_lock);
			if ( sat->st->h.write_abort_type ) {
				sat->st->h.write_tid = get_tid();
				sat->st->h.write_in_time = get_xltime();
			}
			unlock_task(stream_lock,"s_write");

			er = (*tbl->write)(sat->st,pp,ss);


			lock_task(stream_lock);
			sat->st->h.write_tid = 0;
			sat->st->h.write_in_time = 0;
			unlock_task(stream_lock,"s_write(2)");

			if ( er < 0 ) {
				if ( errno == ESYS_AGAIN ) {
					ss = ss/2;
					if ( ss <= 0 )
						ss = 1;
					goto retry;
				}
				if ( erp )
					*erp = errno;
				sat->err = -1;
				break;
			}
			else calc_checksum(sat->st,pp,er,2);
			if ( er == 0 )
				break;
			pp += er;
			ptr -= er;
		}


		
		s_delete_thread(sat->st,&t);
	}
	sat->str_buf_ptr = 0;
	return sat->err;
}


int
_write_spsat(S_PRINTF_SAT * sat,L_CHAR * data,int len)
{
int rem;
	rem = S_PRINTF_OUTPUT_BUF_LEN - sat->str_buf_ptr;
	if ( rem >= len ) {
		memcpy(&sat->str_buf[sat->str_buf_ptr],data,len*sizeof(L_CHAR));
		sat->str_buf_ptr += len;
		return len;
	}
	else {
		memcpy(&sat->str_buf[sat->str_buf_ptr],data,rem*sizeof(L_CHAR));
		sat->str_buf_ptr += rem;
		return rem;
	}
}

int
write_spsat(S_PRINTF_SAT * sat,L_CHAR * data,int len)
{
int er;
	if ( sat->err < 0 )
		return -1;
	for ( ; len ; ) {
		if ( sat->str_buf_ptr == S_PRINTF_OUTPUT_BUF_LEN ) {
			er = 0;
			if ( flush_spsat(sat,&er) < 0 )
				return -1;
			if ( er < 0 )
				return -1;
		}
		er = _write_spsat(sat,data,len);
		len -= er;
		data += er;
	}
	return 0;
}

int
new_spsat(S_PRINTF_SAT * sat,STREAM * st)
{
	if ( st == 0 )
		return -1;
	memset(sat,0,sizeof(*sat));
	sat->st = st;
	sat->str_buf = d_alloc(S_PRINTF_OUTPUT_BUF_LEN*sizeof(L_CHAR));
	return 0;
}

int
finish_spsat(S_PRINTF_SAT * sat,int * erp)
{
int i;
int ret;
	ret = 0;
	if ( sat->str_buf_ptr )
		ret = flush_spsat(sat,erp);
	d_f_ree(sat->str_buf);
	for ( i = 0 ; i < SPSAT_MAX ; i ++ )
		if ( sat->alc[i] )
			d_f_ree(sat->alc[i]);
	return ret;
}


int 
_s_printf_2(S_PRINTF_SAT * sat,int * erp,const char * fmt, va_list p){
	S_PRINTF_STREAM out;
	char *in_begin;
	char *in_end;
	char *temp;
	char type;
	char prefix;
	
	char single_format[64];
	char * single_format_dest;
	
	single_format_dest = malloc(10000);
	memset(&out, 0, sizeof(S_PRINTF_STREAM));


	temp = get_spsat(sat,SPSAT_TEMP,strlen(fmt)+1);
	
	/* begin parse */
	in_begin = (char*)fmt;

	while(*in_begin){
		in_end = in_begin;
		/* read to '%' */
		in_end = strchr(in_end, '%');
		if(in_end==NULL){
			in_end = in_begin + strlen(in_begin);
		}
		
		/* write string who has no format */
		if(in_begin != in_end){
			strncpy(temp, in_begin, in_end-in_begin);
			temp[in_end-in_begin] = '\0';
			put_lstr(&out, l_string(&utf8_cm, temp),sat);
			/* end of format string */
			if(!*in_end){
				break;
			}
		}
		
		/* parse format string that is ... */
		/* [flags] [width] [precision] [{h | l | I64 | L}]type */
		in_begin = in_end;
		++in_end;
		
		prefix = ' ';

		/* flags */
		if(strspn(in_end, "+- 0#") != 0)
			++in_end;
		/* width */
		in_end += strspn(in_end, "0123456789*");
		/* precision */
		if(*in_end == '.')
			in_end+=2;
		/* prefix */
		if(!strncmp(in_end, "I64", 3)){
			prefix = 'L';
			in_end += 3;
		}
		else if(!strncmp(in_end, "ll", 2)){
			prefix = 'L';
			in_end += 2;
		}
		else if(strspn(in_end, "hlL") != 0){
			prefix = *in_end;
			++in_end;
		}
		/* type */
		type = *in_end++;
		
		/* copy single format string */
		strncpy(single_format, in_begin, in_end-in_begin);
		single_format[in_end-in_begin] = '\0';
		
		/* if type is string */
		if(type == 's' || type=='S'){
			if(prefix == 'l' || prefix == 'L'){
				put_lstr(&out, va_arg(p,L_CHAR*),sat);
			}
			else{
				/* what is arg's-char* code ?  std or s->h.cm ?? */
				/* put_lstr(&out, l_string(&utf8_cm, va_arg(p,char*))); */
				put_lstr(&out, l_string(&utf8_cm, va_arg(p,char*)),sat);
			}
		}
		else{
			single_format_dest[0] = '\0';
			switch(type){
				case '%':
					sprintf(single_format_dest, "%%");
					break;
				case 'c':
				case 'C':
				case 'd':
				case 'i':
				case 'o':
				case 'u':
				case 'x':
				case 'X':
					if ( prefix == 'L' )
						sprintf(single_format_dest, single_format, 
								va_arg(p,INTEGER64));
					else	sprintf(single_format_dest, single_format, 
								va_arg(p,int));
					break;
				case 'e':
				case 'E':
				case 'f':
				case 'g':
				case 'G':
					sprintf(single_format_dest, single_format, va_arg(p,double));
					break;
				case 'n':
					sprintf(single_format_dest, single_format, va_arg(p,int*));
					break;
				case 'p':
					sprintf(single_format_dest, single_format, va_arg(p,void*));
					break;
			}
			if(*single_format_dest)
				put_lstr(&out, l_string(&utf8_cm, single_format_dest),sat);
		}
		
		/* update pointer */
		in_begin = in_end;
	}
	
	free(single_format_dest);
	
	if ( out.mem == 0 )
		goto end;

	out.mem[out.len] = 0;
	
	if ( write_spsat(sat,out.mem,out.len) < 0 ) {
		if ( erp )
			*erp = ESYS_INVAL;
		return -1;
	}
end:	

	return out.len;
}

int 
_s_printf(STREAM *s,int * erp,const char * fmt, va_list p,S_PRINTF_SAT * sat)
{

	if ( sat )
		return _s_printf_2(sat,erp,fmt,p);
//return _s_printf_1(sat->st,erp,fmt,p);
	else	return _s_printf_1(s,erp,fmt,p);
}


int
s_printf(STREAM * s,const char * fmt,...)
{
va_list	p;
int ret;

	if ( s == 0 )
		return -1; 
	if ( s->h.check_ptr != &s->h )
		return -1;
	if ( s->h.tbl == 0 )
		return -1;
#ifdef VA2
	va_start(p);
#else
	va_start(p,fmt);
#endif
	ret = _s_printf(s,0, fmt, p,0);
	
	va_end(p);
	return ret;
}

int
ss_printf(const char * fmt,...)
{
va_list	p;
int ret;
STREAM * s;

	s = s_stdout;
	if ( s == 0 )
		return -1; 
	if ( s->h.check_ptr != &s->h )
		return -1;
	if ( s->h.tbl == 0 )
		return -1;
#ifdef VA2
	va_start(p);
#else
	va_start(p,fmt);
#endif

	ret = _s_printf(s,0, fmt, p,0);
	
	va_end(p);
	return ret;
}

int
e_printf(STREAM * s,int * erp,const char * fmt,...)
{
va_list	p;
int ret;

	if ( s == 0 ) {
		if ( erp )
			*erp = ESYS_INVAL;
		return -1; 
	}
	if ( s->h.check_ptr != &s->h ) {
		if ( erp )
			*erp = ESYS_INVAL;
		return -1; 
	}
	if ( s->h.tbl == 0 ) {
		if ( erp )
			*erp = ESYS_INVAL;
		return -1;
	}
#ifdef VA2
	va_start(p);
#else
	va_start(p,fmt);
#endif
	ret = _s_printf(s,erp, fmt, p,0);
	
	va_end(p);
	return ret;
}



int
ss_sprintf(L_CHAR * buf,const char * fmt,...)
{
va_list	p;
int ret;
STREAM * s;
	s = s_open_string_write(&int_cm);
	if ( s == 0 )
		return -1; 
	if ( s->h.check_ptr != &s->h )
		return -1;
	if ( s->h.tbl == 0 )
		return -1;
#ifdef VA2
	va_start(p);
#else
	va_start(p,fmt);
#endif

	ret = _s_printf(s,0, fmt, p,0);
	
	va_end(p);

	memcpy(buf,s->str.str,s->str.size);
	buf[s->str.size/sizeof(L_CHAR)] = 0;
	s_close(s);
	return s->str.size/sizeof(L_CHAR);
}

