/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "machine/include.h"
#include "vpf_std.h"
#include "vpf_table_buffer.h"

/*
static int table_buffer_table_name_comp(
	const char *lhs, const char *rhs){
	return strcmp(lhs,rhs);
}
*/
/*
VPF_TABLE_BUFFER_ITEM *vpf_table_buffer_item_new()
{
	return (VPF_TABLE_BUFFER_ITEM *)calloc(sizeof(VPF_TABLE_BUFFER_ITEM), 1);
}

void vpf_table_buffer_item_delete(VPF_TABLE_BUFFER_ITEM *item)
{
	if(item == NULL)
		return;
	if(item->table_name)
		free(item->table_name);
	vpf_table_delete(item->table);
	free(item);
}
*/
void vpf_table_buffer_item_delete(char *table_name, VPF_TABLE *tbl){
	free(table_name);
	vpf_table_delete(tbl);
}

VPF_TABLE_BUFFER *vpf_table_buff_new(int max_table_count)
{
	VPF_TABLE_BUFFER *buff;
	buff = (VPF_TABLE_BUFFER *)calloc(sizeof(VPF_TABLE_BUFFER),1);
	buff->tables = vpf_map_new((vpf_map_data_destructor_type)vpf_table_buffer_item_delete, (vpf_map_comp_type)strcmp);
	buff->max_table_count = max_table_count;
	return buff;
}

void vpf_table_buff_delete(VPF_TABLE_BUFFER *buff)
{
	if(buff==NULL)
		return;
	vpf_map_delete(buff->tables);
	free(buff);
}


VPF_TABLE *vpf_table_buff_get_table(VPF_TABLE_BUFFER *buff, const char *table_name, VPF_TABLE_TYPE type)
{
	VPF_TABLE *ret;
	VPF_MAP_ITEM *it;
	it = vpf_map_find(buff->tables, table_name);
	if(it){
		ret = (VPF_TABLE *)it->data;
	}
	else{
		ret = vpf_table_new(type);
		if(!vpf_table_load(ret, table_name)){
			vpf_table_delete(ret);
			return NULL;
		}
		vpf_map_push(buff->tables, strdup(table_name), ret);
	}
	return ret;
}

