/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"favt64.h"
#include	"task.h"
#include	"filespace64.h"
#include	"lock_level.h"
#include	"associate64.h"


SEM l_favt64_lock;

void
init_l_favt64()
{
	init_favt64();
	l_favt64_lock = new_lock(LL_FAVT64);
}


FAVT64_NODE *
l_favt64_alloc_node(FAVT64_ROOT * rt,
	void * data,int data_size)
{
FAVT64_NODE * ret;
	lock_task(l_favt64_lock);
	ret = favt64_alloc_node(rt,data,data_size);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}

FAVT64_ROOT *
l_favt64_alloc_root(PDB64 * p,int type,void (*func)())
{
FAVT64_ROOT * ret;
	lock_task(l_favt64_lock);
	ret = favt64_alloc_root(p,type,func);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}


FAVT64_NODE *
l_favt64_delete(int * errp,FAVT64_ROOT * p,FAVT64_PTR * favtp,void * data,int (*cmp)(),void * w)
{
FAVT64_NODE * ret;
	lock_task(l_favt64_lock);
	ret = favt64_delete(errp,p,favtp,data,cmp,w);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}


void
l_favt64_free_node(FAVT64_NODE * n)
{
	lock_task(l_favt64_lock);
	favt64_free_node(n);
	unlock_task(l_favt64_lock,"unlock");
}


FAVT64_NODE *
l_favt64_insert(int * errp,
	FAVT64_ROOT * p,FAVT64_PTR * favtp,FAVT64_NODE * a,int (*cmp)(),void * w)
{
FAVT64_NODE * ret;
	lock_task(l_favt64_lock);
	ret = favt64_insert(errp,p,favtp,a,cmp,w);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}


FAVT64_NODE *
l_favt64_search(int * errp,
	FAVT64_ROOT * p,FAVT64_NODE * a,void * data,int (*cmp)(),void * w)
{
FAVT64_NODE * ret;
	lock_task(l_favt64_lock);
	ret = favt64_search(errp,p,a,data,cmp,w);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}


int
l_favt64_trace_from_small(int * errp,
		FAVT64_ROOT * p,FAVT64_NODE * a,int (*func)(),void * work)
{
int ret;
	lock_task(l_favt64_lock);
	ret = favt64_trace_from_small(errp,p,a,func,work);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}

FAVT64_ROOT *
l_get_root64(int * errp,PDB64 * p,unsigned int fofs,void (*func)())
{
FAVT64_ROOT * ret;
	lock_task(l_favt64_lock);
	ret = get_root64(errp,p,fofs,func);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}


FAVT64_NODE *
l_root_node64(int * errp,FAVT64_ROOT * r)
{
FAVT64_NODE * ret;
	lock_task(l_favt64_lock);
	ret = root_node64(errp,r);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}


void
l_check_cache64(char * str)
{
	lock_task(l_favt64_lock);
	check_cache64(str);
	unlock_task(l_favt64_lock,"unlock");
}


int
l_favt64_trace_from_large(int * errp,
		FAVT64_ROOT * p,FAVT64_NODE * a,int (*func)(),void * work)
{
int ret;
	lock_task(l_favt64_lock);
	ret = favt64_trace_from_large(errp,p,a,func,work);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}


void
l_flush_favt64_cache(PDB64 * p)
{
	lock_task(l_favt64_lock);
	flush_favt64_cache(p);
	unlock_task(l_favt64_lock,"unlock");
}



void
l_flush_filespace64(PDB64 * p)
{
	lock_task(l_favt64_lock);
	flush_filespace64(p);
	unlock_task(l_favt64_lock,"unlock");
}


void
l_close_filespace64(PDB64 * p)
{
	lock_task(l_favt64_lock);
	close_filespace64(p);
	unlock_task(l_favt64_lock,"unlock");
}

int
l_write_filespace64(PDB64 * p,void * h)
{
int ret;
	lock_task(l_favt64_lock);
	ret = write_filespace64(p,h);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}

int
l_write_filespace64f(PDB64 * p,U_INTEGER64 fofs,void * h)
{
int ret;
	lock_task(l_favt64_lock);
	ret = write_filespace64f(p,fofs,h);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}

void *
l_read_filespace64(PDB64 * p,U_INTEGER64 fofs)
{
void * ret;
	lock_task(l_favt64_lock);
	ret = read_filespace64(p,fofs);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}

void *
l_read_filespace64_header
	(PDB64 * p,U_INTEGER64 fofs)
{
void * ret;
	lock_task(l_favt64_lock);
	ret = read_filespace64_header(p,fofs);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}

void *
l_read_filespace64f_header
	(PDB64 * p,U_INTEGER64 fofs)
{
void * ret;
	lock_task(l_favt64_lock);
	ret = read_filespace64f_header(p,fofs);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}

void *
l_read_filespace64f(PDB64 * p,U_INTEGER64 fofs)
{
void * ret;
	lock_task(l_favt64_lock);
	ret = read_filespace64f(p,fofs);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}

void
l_free_filespace64(PDB64 * p,U_INTEGER64 fofs)
{
	lock_task(l_favt64_lock);
	free_filespace64(p,fofs);
	unlock_task(l_favt64_lock,"unlock");
}
INTEGER64
l_alloc_filespace64(PDB64 * p,PN64_HEADER * h)
{
INTEGER64 ret;
	lock_task(l_favt64_lock);
	ret = alloc_filespace64(p,h);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}

BOUND64_LIST *
l_favt64_bound_search(
	int * errp,
	FAVT64_ROOT * p,
	FAVT64_NODE * a,
	void *	data_min,
	void *	data_max,
	int	limit,
	int (*cmp)(),
	void * cw)
{
BOUND64_LIST * ret;
	lock_task(l_favt64_lock);
	ret = favt64_bound_search(
		errp,
		p,
		a,
		data_min,
		data_max,
		limit,
		cmp,
		cw);
	unlock_task(l_favt64_lock,"unlock");
	return ret;
}



int
l_open_associate64(
	char * filename,
	int oflags,
	int mode,
	int flags,
	int type,
	char * encoding)
{
int ret;
	lock_task(l_favt64_lock);
	ret = open_associate64(filename,oflags,mode,flags,type,encoding);
	unlock_task(l_favt64_lock,"iunlock");
	return ret;
}

void
l_close_associate64(int key)
{
	lock_task(l_favt64_lock);
	close_associate64(key);
	unlock_task(l_favt64_lock,"close_associate64");
}


int l_insert_associate64(int key,int index,void * from,XL_SEXP * data)
{
int ret;
	lock_task(l_favt64_lock);
	ret = insert_associate64(key,index,from,data);
	unlock_task(l_favt64_lock,"iunlock");
	return ret;
}


XL_SEXP * l_search_associate64(int key,int index,void * from,void * opt)
{
XL_SEXP* ret;
	lock_task(l_favt64_lock);
	ret = search_associate64(key,index,from,opt);
	unlock_task(l_favt64_lock,"iunlock");
	return ret;
}


int l_get_index64(int key,short name)
{
int ret;
	lock_task(l_favt64_lock);
	ret = get_index64(key,name);
	unlock_task(l_favt64_lock,"iunlock");
	return ret;
}


int l_new_index64(int key,short type,short name)
{
int ret;
	lock_task(l_favt64_lock);
	ret = new_index64(key,type,name);
	unlock_task(l_favt64_lock,"iunlock");
	return ret;
}


int l_get_index_type64(int key,int index)
{
int ret;
	lock_task(l_favt64_lock);
	ret = get_index_type64(key,index);
	unlock_task(l_favt64_lock,"iunlock");
	return ret;
}


XL_SEXP * l_get_assoc64_all(int key,int index)
{
XL_SEXP * ret;
	lock_task(l_favt64_lock);
	ret = get_assoc64_all(key,index);
	unlock_task(l_favt64_lock,"iunlock");
	return ret;
}


int l_delete_associate64(int key,int index,void * from)
{
int ret;
	lock_task(l_favt64_lock);
	ret = delete_associate64(key,index,from);
	unlock_task(l_favt64_lock,"iunlock");
	return ret;
}


void
l_truncate_filespace64(PDB64 * p)
{
	lock_task(l_favt64_lock);
	truncate_filespace64(p);
	unlock_task(l_favt64_lock,"unlock");
}



