/**********************************************************************
 
	Copyright (C) 2007- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"task.h"
#include	"utils.h"
#include	"u_file.h"
#include	"fa_cache.h"
#include	"memory_debug.h"

#define DATA_MALLOC	d_alloc
#define DATA_FREE	d_f_ree

void
fa_print_dump(char*,FAC_ENTRY * e,int ptr,int size);

FAC_GENERAL	fac_general_info;

void
fac_init_general()
{
	fac_general_info.total_entries = FAC_DEFAULT_ENTRIES;
	fac_general_info.entries.prev 
		= fac_general_info.entries.next
		= &fac_general_info.entries;
	fac_general_info.info_list.next
		= fac_general_info.info_list.prev
		= &fac_general_info.info_list;
}

void
fac_init(FAC_INFO * info)
{
	if ( fac_general_info.total_entries == 0 )
		return;
	info->seek_point = 0;
	if ( info->long_file )
		info->file_size = u_lseek64(info->fd,0,SEEK_END);
	else	info->file_size = u_lseek(info->fd,0,SEEK_END);
	info->real_file_size = info->file_size;
	info->entries_tree = 0;

	info->h.prev = &fac_general_info.info_list;
	info->h.next = fac_general_info.info_list.next;
	info->h.prev->next = &info->h;
	info->h.next->prev = &info->h;
}

int
fac_cmp(FAC_ENTRY * e1,FAC_ENTRY * e2)
{
	if ( e1->offset < e2->offset )
		return -1;
	if ( e1->offset > e2->offset )
		return 1;
	return 0;
}

void
fac_delete(FAC_ENTRY_HEADER * e)
{
	e->next->prev = e->prev;
	e->prev->next = e->next;
}

void
fac_insert(FAC_ENTRY_HEADER * e,FAC_ENTRY_HEADER * n)
{
	n->prev = e;
	n->next = e->next;
	n->prev->next = n;
	n->next->prev = n;
}



FAC_ENTRY *
get_entry(int *status,FAC_INFO * info,U_INTEGER64 offset)
{
FAC_ENTRY * ret;
FAC_ENTRY cond;
AVT_NODE * n1,*n2;
U_INTEGER64 len;
FAC_ENTRY * e,*e2;


	if ( offset > info->file_size )
		return 0;
	cond.offset = offset & (-(INTEGER64)FAC_SIZE);
	n1 = avt_search(info->entries_tree,&cond,fac_cmp);
	if ( n1 == 0 ) {
		ret = d_alloc(sizeof(*ret));
		memset(ret,0,sizeof(*ret));
		ret->offset = cond.offset;
		ret->create_time = get_xltime();
		ret->data = DATA_MALLOC(FAC_SIZE);
		n1 = d_alloc(sizeof(*n1));
		ret->info = info;
		n1->data = ret;
		n2 = avt_insert(&info->entries_tree,n1,fac_cmp);
		if ( n2  != n1 )
			er_panic("get_entry");
		len = info->file_size - cond.offset;
		if ( len > FAC_SIZE )
			ret->len = FAC_SIZE;
		else	ret->len = len;
		*status = 1;
		fac_general_info.entries_nos ++;
	}
	else {
		ret = n1->data;
		*status = 0;
		fac_delete(&ret->h);
	}
	fac_insert(&fac_general_info.entries,&ret->h);
	ret->access_time = get_xltime();
	e = (FAC_ENTRY*)fac_general_info.entries.prev;
	for ( ; fac_general_info.entries_nos > fac_general_info.total_entries ;  ) {
		for ( ; ((&e->h != &fac_general_info.entries) && 
				e->dirty) || e == ret ; e = (FAC_ENTRY*)e->h.prev );
		if (&e->h == &fac_general_info.entries)
			break;
		e2 = (FAC_ENTRY*)e->h.prev;
		fac_delete(&e->h);
		fac_general_info.entries_nos --;
		n1 = avt_delete(&e->info->entries_tree,e,fac_cmp);
		if ( n1 == 0 )
			er_panic("get_entry");
		if( n1->data != (void*)e )
			er_panic("get_entry");
		d_f_ree(n1);
		DATA_FREE(e->data);
		d_f_ree(e);
		e = e2;
	}
	return ret;
}


void
fa_print_dump(char * msg,FAC_ENTRY * e,int _ptr,int size)
{
unsigned char * ptr;
int i,r;
	i = _ptr;
	r = i % 20;
	i -= r;
	if ( size < 0 )
		size = FAC_SIZE;
	else	size += _ptr;
	ptr = (unsigned char*)e->data;
	ss_printf("%s [%i %i : %i %i]\n",msg,e->len,size,_ptr,size);
	ss_printf("%s %04i = ",msg,i);
	for ( ; (i < e->len) && (i < size) ; i ++ ) {
		ss_printf("%02x ",ptr[i]);
		if ( (i % 20) == 19 ) {
			ss_printf("\n");
			ss_printf("%s %04i = ",msg,i+1);
		}
		else if ( (i % 10) == 9 ) {
			ss_printf("+ ");
		}
		else if ( (i % 5) == 4 ) {
			ss_printf("- ");
		}
	}
	ss_printf("\n");
}

int
fac_trace_func(AVT_NODE * a,void * w)
{
FAC_INFO * info;
FAC_ENTRY * e;
	e = a->data;
	if ( e->dirty == 0 )
		return 0;
	info = (FAC_INFO*)w;
	if ( info->long_file )
		u_lseek64(info->fd,e->offset,SEEK_SET);
	else	u_lseek(info->fd,e->offset,SEEK_SET);
	u_write(info->fd,e->data,e->len);
	if ( e->offset + e->len >= info->real_file_size )
		info->real_file_size = e->offset + e->len;
	e->dirty = 0;
	fac_general_info.dirty_nos --;
	return 0;
}

void
fac_purge_onlyone(FAC_INFO * info)
{
	avt_trace_from_small(info->entries_tree,fac_trace_func,info);
	if ( info->real_file_size != info->file_size )
		er_panic("fac_purge(2)");
}

void
fac_purge_all()
{
FAC_INFO * info;
	for ( info = (FAC_INFO*)fac_general_info.info_list.next ;
		&info->h != &fac_general_info.info_list;
		info = (FAC_INFO*)info->h.next ) {

		fac_purge_onlyone(info);
	}
	if ( fac_general_info.dirty_nos )
		er_panic("fac_purge");
}

void
fac_flush(FAC_INFO * info)
{
	if ( fac_general_info.total_entries == 0 )
		return;
	fac_purge_onlyone(info);
}

void
fac_close(FAC_INFO * info)
{
FAC_ENTRY * e;
AVT_NODE * n;

	if ( fac_general_info.total_entries == 0 )
		return;
	fac_purge_onlyone(info);
	for ( ; info->entries_tree ; ) {
		e = (FAC_ENTRY*)info->entries_tree->data;
		fac_delete(&e->h);
		n = avt_delete(&info->entries_tree,e,fac_cmp);
		if ( n == 0 )
			er_panic("fac_close");
		if ( n->data != (void*)e )
			er_panic("fac_close");
		d_f_ree(n);
		DATA_FREE(e->data);
		d_f_ree(e);
		fac_general_info.entries_nos --;
	}
	info->h.prev->next = info->h.next;
	info->h.next->prev = info->h.prev;
}

int
fac_read(FAC_INFO * info,void * _data,int len)
{
int ret;
int s;
U_INTEGER64 offset,this_ofs;
FAC_ENTRY * e;
int ptr;
int status;
char * data;

	if ( fac_general_info.total_entries == 0 )
		return u_read(info->fd,_data,len);
	data = (char*)_data;
	ret = 0;
	offset = info->seek_point;
	for ( ; len > 0 ; ) {
		this_ofs = offset & (-(INTEGER64)FAC_SIZE);
		e = get_entry(&status,info,this_ofs);
		if ( e == 0 ) {
			errno = EIO;
			ret = -1;
			break;
		}
		if ( status ) {
			if ( info->long_file ) {
				u_lseek64(info->fd,e->offset,SEEK_SET);
				if ( e->len )
					u_read(info->fd,e->data,e->len);
			}
			else {
				u_lseek(info->fd,e->offset,SEEK_SET);
				if ( e->len )
					u_read(info->fd,e->data,e->len);
			}
		}
		ptr = offset - this_ofs;
		if ( ptr > e->len ) {
			errno = EIO;
			ret = -1;
			break;
		}
		if ( ptr + len > e->len )
			s = e->len - ptr;
		else	s = len;
		memcpy(data,&e->data[ptr],s);
		data += s;
		len -= s;
		offset += s;
		ret += s;
		if ( s == 0 )
			break;
	}
	info->seek_point = offset;
	return ret;
}

int
fac_write(FAC_INFO * info,void * _data,int len)
{
int ret;
int s;
U_INTEGER64 offset,this_ofs;
FAC_ENTRY * e;
int ptr;
int status;
int _ret;
char * data;


 	if ( fac_general_info.total_entries == 0 )
		return u_write(info->fd,_data,len);
	data = (char*)_data;
	ret = 0;
	offset = info->seek_point;


	for ( ; len > 0 ; ) {
		this_ofs = offset & (-(INTEGER64)FAC_SIZE);
		e = get_entry(&status,info,this_ofs);
		if ( e == 0 ) {
			errno = EIO;
			ret = -1;
			break;
		}
		_ret = -1;
		ptr = offset - this_ofs;
		if ( ptr > e->len ) {
			errno = EIO;
			ret = -1;
			break;
		}
		_ret = 0;
		if ( ptr + len > FAC_SIZE )
			s = FAC_SIZE - ptr;
		else	s = len;
		if ( status && (ptr || ptr+s < e->len) && (info->real_file_size > e->offset) ) {
			if ( info->long_file ) {
				u_lseek64(info->fd,e->offset,SEEK_SET);
				if ( e->len )
					u_read(info->fd,e->data,e->len);
			}
			else {
				u_lseek(info->fd,e->offset,SEEK_SET);
				if ( e->len )
					u_read(info->fd,e->data,e->len);
			}
			if ( _ret )
				break;
		}
		if ( s ) {
			if ( e->dirty == 0 ) {
				e->dirty = 1;
				fac_general_info.dirty_nos ++;
			}
		}

		memcpy(&e->data[ptr],data,s);
		if ( e->len < ptr + s )
			e->len = ptr + s;
		data += s;
		len -= s;
		offset += s;
		ret += s;
		if ( info->file_size < offset )
			info->file_size = offset;
	}
	info->seek_point = offset;
	if ( info->file_size < offset )
		info->file_size = offset;
	if ( fac_general_info.total_entries 
			* FAC_DIRTY_RATE <= 
			fac_general_info.dirty_nos )
		fac_purge_all(info);
	return ret;
}


INTEGER64 
fac_lseek(FAC_INFO * info,INTEGER64 ofs,int pos)
{
	if ( fac_general_info.total_entries == 0 )
		return u_lseek(info->fd,ofs,pos);
	switch ( pos ) {
	case SEEK_SET:
		break;
	case SEEK_CUR:
		ofs = info->seek_point + ofs;
		break;
	case SEEK_END:
		ofs = info->file_size + ofs;
		break;
	default:
		return -1;
	}
	if ( ofs < 0 )
		return -2;
	if ( ofs > info->file_size )
		return -3;
	info->seek_point = ofs;
	return ofs;
}

typedef struct fac_ttt {
	FAC_INFO *		info;
	FAC_ENTRY *		del;
} FAC_TTT;

int
fac_truncate_trace(AVT_NODE * a,void * work)
{
FAC_ENTRY * e;
FAC_TTT * t;
	t = work;
	e = a->data;
	if ( e->offset > t->info->file_size ) {
		t->del = e;
	}
	else if ( e->offset <= t->info->file_size && e->offset + e->len >= t->info->file_size ) {
		e->len = t->info->file_size - e->offset;
		t->del = 0;
	}
	return 1;
}


int
fac_truncate(FAC_INFO * info,U_INTEGER64 length)
{
FAC_TTT t;
FAC_ENTRY * e1;
AVT_NODE * n;
INTEGER64 real_length;
	if ( fac_general_info.total_entries == 0 )
		return ftruncate64(info->fd,length);
	if ( length > info->file_size )
		return -1;
	info->file_size = length;
	if ( info->seek_point > info->file_size )
		info->seek_point = info->file_size;
	t.info = info;
	for ( ; ; ) {
		t.del = 0;
		avt_trace_from_large(info->entries_tree,fac_truncate_trace,&t);
		if ( t.del == 0 )
			break;
		n = avt_delete(&info->entries_tree,t.del->data,fac_cmp);
		if ( n->data != (void*)t.del )
			er_panic("fac_truncate");
		e1 = n->data;
		if ( e1->data )
			DATA_FREE(e1->data);
		if ( e1->dirty )
			fac_general_info.dirty_nos --;
		fac_general_info.entries_nos --;
		fac_delete(&e1->h);
		d_f_ree(e1);
	}
	real_length = u_lseek64(info->fd,0,SEEK_END);
	if ( length < real_length ) {
		ftruncate64(info->fd,length);
		info->real_file_size = length;
	}
	else	info->real_file_size = real_length;
	return 0;
}



