/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"lc_encode.h"
#include	"tr_html.h"

XL_SEXP * html_font();

void
init_html_font(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"FONT"),
		get_func_prim(html_font,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
html_font(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * _color;
int c,color;
TR_HTML_INFO * inf;
	inf = tr_get_html_info(env);
	if ( inf == 0 )
		return 0;
	_color = get_sf_attribute(sf,l_string(std_cm,"COLOR"));
	if ( _color ) {
		if ( _color[0] == '#' )
			_color++;
		sscanf(n_string(std_cm,_color),"%x",&c);
		color = COL(
			((c>>16)&0xff)<<(COL_BIT-8),
			((c>>8)&0xff)<<(COL_BIT-8),
			((c&0xff)<<(COL_BIT-8)));
		_tr_set_attr_int_data(&inf->d.attr_stack->attr,
				TRAT_COLOR,color);
	}
	return 0;
}


