/**********************************************************************
 
	Copyright (C) 2006-2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___PROGRESSIVE_H___
#define ___PROGRESSIVE_H___

#include	"machine/include.h"
#include	"xl.h"


typedef struct cmd_que_header {
	union cmd_que *		next;
	int			type;
#define CQT_NEW_PROGRESSIVE	1
#define CQT_CLOSE_PROGRESSIVE	2
#define CQT_NEW_STAGE		3
#define CQT_NEXT_STAGE		4
#define CQT_SET_STAGE		5
	XL_INTERPRETER *	xli;
	int			prog_id;
	int			stage_id;
	int			err;
	unsigned 		end_flag:1;
} CMD_QUE_HEADER;

typedef struct cq_new_progressve {
	CMD_QUE_HEADER		h;
	L_CHAR *		description;
	L_CHAR *		attach_file;
} CQ_NEW_PROGRESSIVE;

typedef struct cq_close_progressive {
	CMD_QUE_HEADER		h;
} CQ_CLOSE_PROGRESSIVE;

typedef struct cq_new_stage {
	CMD_QUE_HEADER		h;
	L_CHAR *		description;
	int			drsp;
} CQ_NEW_STAGE;

typedef struct cq_next_stage {
	CMD_QUE_HEADER		h;
	double			total_jobs;
} CQ_NEXT_STAGE;

typedef struct cq_set_stage {
	CMD_QUE_HEADER		h;
	L_CHAR *		message;
	double			finished_jobs;
} CQ_SET_STAGE;

typedef union cmd_que {
	CMD_QUE_HEADER		h;
	CQ_NEW_PROGRESSIVE	np;
	CQ_CLOSE_PROGRESSIVE	cp;
	CQ_NEW_STAGE		ns;
	CQ_NEXT_STAGE		xs;
	CQ_SET_STAGE		ss;
} CMD_QUE;

typedef struct access_keeper {
	INTEGER64		check;
	int			count;
	double			avg;
	int			ignore_count;
} ACCESS_KEEPER;

#define AK_RATE		0.8
#define AK_INTERVAL	10

typedef struct uplink_info {
	struct uplink_info *	next;
	XL_INTERPRETER *	xli;
	CMD_QUE *		cq_head;
	CMD_QUE *		cq_tail;
	ACCESS_KEEPER		ak;
	unsigned		uplink:1;
} UPLINK_INFO;



typedef struct p_stage {
	struct p_stage *	next;
	int			id;
	L_CHAR *		description;
	L_CHAR *		message;
	struct progressive *	sub_progressive;
	INTEGER64		start_time;
	double			total_jobs;
	double			finished_jobs;
	
	int			total_time;
	ACCESS_KEEPER		ak;

	struct progressive *	parent;
	
	unsigned		dont_remove_sub_progressive:1;
} P_STAGE;

typedef struct progressive {
	struct progressive *	next;
	int			id;
	L_CHAR *		description;
	L_CHAR *		file;
	P_STAGE *		stages;
	P_STAGE *		interrested_stage;
	INTEGER64		start_time;

	XL_INTERPRETER *	base_xli;
	
	P_STAGE *		parent_stage;
} PROGRESSIVE;


void
init_progressive(XLISP_ENV*);
int
new_progressive(L_CHAR * description,L_CHAR * attach_file,int inp_flag);
void
close_progressive(int id,int inp_flag);
int
new_stage(int id,L_CHAR * description,int drsp,int inp_flag);
int
next_stage(int prog_id,int sid,double total_jobs,int inp_flag);
int
set_stage(int prog_id,L_CHAR * message,double finished_jobs,int inp_flag);

#endif


