/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___PDB64_BASIC_H___
#define ___PDB64_BASIC_H___


#include	"machine/include.h"
#include	"fa_cache.h"

/* PDB define */

#ifndef PDB_ORG
#include	"pdb.h"
#endif
#ifdef PDB_ORG


typedef struct pn_header {
	unsigned short	type;
	unsigned short	size;
} PN_HEADER;

#define PF_USEFREELIST	0x80000000
#define FSF_ONLYHEADER	0x00000001
#define FSF_RESERVE_SP	0x00000002

#define PNT_TYPE_MASK		0x00ff
#define PNT_GROUP_MASK		0xff00
#define PNT_GET_GROUP(x)	(((x)&PNT_GROUP_MASK)>>8)

#define PNT_GROUP_MAX		3

#define PNT_POLYGON_GROUP	0x0000
#define PNT_FILE_HEADER		1
#define PNT_2D_DRAW_HEADER	2
#define PNT_LOD_LIST		3
#define PNT_TREE_NODE		4
#define PNT_POLYGON2D		5
#define PNT_POLY_POINT		6	
#define PNT_POLY_END		7
#define PNT_LNO_POLY_POINT	8
#define PNT_POLY_MAX		9

#define PNT_FAVT_GROUP		1
#define PNT_FAVT_ROOT		((PNT_FAVT_GROUP<<8)|1)
#define PNT_FAVT_NODE		((PNT_FAVT_GROUP<<8)|2)
#define PNT_FREELIST_HEADER	((PNT_FAVT_GROUP<<8)|3)
#define PNT_FREELIST_NODE	((PNT_FAVT_GROUP<<8)|4)
#define PNT_DTREE_DATA		((PNT_FAVT_GROUP<<8)|5)
#define PNT_FAVT_MAX		6

#define PNT_ASSOC_GROUP		2
#define PNT_ASSOC_HEADER	((PNT_ASSOC_GROUP<<8)|1)
#define PNT_ASSOC_DATA		((PNT_ASSOC_GROUP<<8)|2)

#define PNT_PMD_GROUP		3
#define PNT_PMD_HEADER		((PNT_PMD_GROUP<<8)|1)
#define PNT_PMD_NODE		((PNT_PMD_GROUP<<8)|2)
#define PNT_PMD_MD		((PNT_PMD_GROUP<<8)|3)
#define PNT_PMD_OFSLIST		((PNT_PMD_GROUP<<8)|4)

#define PNT_RT_CACHE_GROUP	4
#define PNT_RT_CACHE_HEADER	((PNT_RT_CACHE_GROUP<<8)|1)
#define PNT_RT_CACHE_DATA	((PNT_RT_CACHE_GROUP<<8)|2)
#define PNT_RT_CACHE_LIST	((PNT_RT_CACHE_GROUP<<8)|3)

#define PNT_RS_CACHE_GROUP	5
#define PNT_RS_CACHE_NULL	((PNT_RS_CACHE_GROUP<<8)|0)
#define PNT_RS_CACHE_HEADER	((PNT_RS_CACHE_GROUP<<8)|1)
#define PNT_RS_CACHE_DATA	((PNT_RS_CACHE_GROUP<<8)|2)
#define PNT_RS_RES_STATUS	((PNT_RS_CACHE_GROUP<<8)|3)
#define PNT_RS_COORDINATE	((PNT_RS_CACHE_GROUP<<8)|4)
#define PNT_RS_PIXEL_MAP_R64	((PNT_RS_CACHE_GROUP<<8)|5)
#define PNT_RS_DRAW_GB		((PNT_RS_CACHE_GROUP<<8)|6)
#define PNT_RS_RES_MAP		((PNT_RS_CACHE_GROUP<<8)|7)
#define PNT_RS_BIB_LIST		((PNT_RS_CACHE_GROUP<<8)|8)
#define PNT_RS_NOTE		((PNT_RS_CACHE_GROUP<<8)|9)
#define PNT_RS_CLIP		((PNT_RS_CACHE_GROUP<<8)|10)
#define PNT_RS_MAP		((PNT_RS_CACHE_GROUP<<8)|11)
#define PNT_RS_INFO_SCHEME	((PNT_RS_CACHE_GROUP<<8)|12)
#define PNT_RS_TRIANGLE		((PNT_RS_CACHE_GROUP<<8)|13)
#define PNT_RS_MAP_POINT_LIST	((PNT_RS_CACHE_GROUP<<8)|14)

#endif
/* PDB define END */


#define PNT_MX_GROUP		6
#define PNT_MX_HEADER	((PNT_MX_GROUP<<8)|0)
#define PNT_MX_SUBHEADER ((PNT_MX_GROUP<<8)|1)
#define PNT_MX_DATA_1	((PNT_MX_GROUP<<8)|2)
#define PNT_MX_DATA_2	((PNT_MX_GROUP<<8)|3)
#define PNT_MX_CAL	((PNT_MX_GROUP<<8)|4)
#define PNT_MX_DIM_ADDR	((PNT_MX_GROUP<<8)|5)
#define PNT_MX_NODE	((PNT_MX_GROUP<<8)|6)
#define PNT_MX_CACHE_RING ((PNT_MX_GROUP<<8)|7)



#define PHYS_SIZE32	0xfffe
#define PHYS_SIZE64	0xffff
#define PHYS_SIZE16_LIMIT \
	(PHYS_SIZE32 + sizeof(PN64_HEADER) - sizeof(PN_HEADER))

#define PHYS_SIZE(x) \
	((x) < PHYS_SIZE16_LIMIT ? \
		(x) - sizeof(PN64_HEADER) + sizeof(PN_HEADER) :	\
		((x) < ((INTEGER64)CONST_INT64(0x100000000)) ?		\
			(x) - sizeof(PN64_HEADER)		\
				+ sizeof(_PN32_HEADER)		\
			:					\
			(x) - sizeof(PN64_HEADER)		\
				+ sizeof(_PN64_HEADER)))

#define LOGI_SIZE(x) \
	((x) < PHYS_SIZE16_LIMIT - sizeof(PN64_HEADER) + sizeof(PN_HEADER) ? \
		(x) + sizeof(PN64_HEADER) - sizeof(PN_HEADER) : \
		((x) < ((INTEGER64)CONST_INT64(0x100000000)) 	\
				+ sizeof(PN64_HEADER)		\
				- sizeof(_PN32_HEADER)	 ?	\
			(x) + sizeof(PN64_HEADER)		\
				- sizeof(_PN32_HEADER)		\
			:					\
			(x) + sizeof(PN64_HEADER)		\
				- sizeof(_PN64_HEADER)))


typedef struct _pn32_header {
	PN_HEADER	h16;
	unsigned int	size;
} _PN32_HEADER;

typedef struct _pn64_header {
	PN_HEADER	h16;
	U_INTEGER64	size;
} _PN64_HEADER;

typedef union phys_pn64_header {
	PN_HEADER	h16;
	_PN32_HEADER	h32;
	_PN64_HEADER	h64;
} PHYS_PN64_HEADER;

#define HD_SIZE(h)	\
		(h->h16.size == PHYS_SIZE32 ?		\
			sizeof(_PN32_HEADER) :		\
			(h->h16.size == PHYS_SIZE64 ?	\
				sizeof(_PN64_HEADER) :	\
				sizeof(PN_HEADER)))

typedef struct pn64_header {
	unsigned short		type;
	unsigned short		dummy[3];
	U_INTEGER64		size;
} PN64_HEADER;

typedef struct acc64_header {
	U_INTEGER64	fofs;
} ACC64_HEADER;

typedef struct acc_pn64_header {
	ACC64_HEADER	a;
	PN64_HEADER	h;
} ACC_PN64_HEADER;


typedef struct pdb64_debug {
	INTEGER64	fofs;
	INTEGER64	size;
} PDB64_DEBUG;

typedef struct pdb64 {
	int		fid;
	int		flags;
#define PF_PDB_MASK	0x0000ffff
#define PF_CACHE	0x00000001

#define PF_DEBUG	0x80000000
#define PF_NEST_DEBUG	0x40000000
	U_INTEGER64	fofs;
/*
	PDB_REQUEST *	request;
	PDB_REQUEST *	next_request;
	FA_CACHE *	cache;
	char		data[DF_BUF];
	int		buf_ptr;
	int		buf_len;
	unsigned int	seek_ptr;
*/
	int		oflags;
	void *		freelist_work;

	AVT_NODE *	pdb64_debug_root;
#define DT_INSERT	1
#define DT_SEARCH	2
#define DT_DP_SEARCH	3
#define DT_DELETE	4
#define DT_ALL_DELETE	5
#define DT_BOUNDARY	6
#define DT_POS		0x8000
#define DT_CMD		0x00ff
	FAC_INFO	fac;
} PDB64;


/*******************************/


typedef struct pn64_file_header {
	PN64_HEADER	h;
	int		type;	/* file type */
#define FT_2D_DRAW		1	/* draw file */
#define FT_2D_MAP		2	/* map file */
#define FT_2D_COORDINATE	3	/* coordinate system definition file */
#define FT_ADDRESS_LUMP		10	/* address lump system */
#define FT_RT_CACHE		11	/* routing cache */
#define FT_HWF			12	/* Heuristics Window Frame */
#define FT_ADDRESS_DB  21 /* address database */





#define FT_MATRIX		31

	char		version[8];
#define PDB64_VERSION		"64-0.6"

#define ENCODING_SIZE	8
	char		encoding[ENCODING_SIZE];
	unsigned int	linear;
	int		flags;
#define FTF_WRITE	0x00000001
} PN64_FILE_HEADER;
#define PN64_FILE_HEADER_S	sizeof(PN64_FILE_HEADER)



/*******************************/
/*
	FILE AVT 
*/
/*******************************/

typedef struct pn64_favt_root {
	PN64_HEADER	h;
	int		type;
#define FAST_DTREE	0x00000001
#define FAST_OTHER_TREE	0x00000000
#define FAST_DTREE_ROOT	0x00000001

#define FAT_DTREE_NODE	2

	U_INTEGER64	node;
} PN64_FAVT_ROOT;

#define PN64_FAVT_ROOT_S		sizeof(PN64_FAVT_ROOT)

typedef struct pn64_favt_node {
	PN64_HEADER	h;
	U_INTEGER64	small;
	U_INTEGER64	large;
	int		level;
	/* user data is followed */
} PN64_FAVT_NODE;

#define PN64_FVAT_NODE_S		sizeof(PN64_FAVT_NODE)

typedef struct pn64_freelist {
	PN64_HEADER	h;
	U_INTEGER64	next;
} PN64_FREELIST;


typedef struct pn64_dtree_data {
	PN64_HEADER	h;
	U_INTEGER64	data[1];
	/* two or more data are allowed */
} PN64_DTREE_DATA;

#define PN64_DTREE_DATA_S(x)	((int)(&((PN64_DTREE_DATA*)0)->data[x]))


void
change_endian_phys_header64_to_host(PHYS_PN64_HEADER * h);
void
change_endian_phys_header64_to_net(PHYS_PN64_HEADER * h);
void
change_endian_header64(PN64_HEADER * h);
void
change_endian_file_header64(PN64_FILE_HEADER * f);

PDB64 * open_pdb64(char * filename,int oflags,int mode,int flags);
void close_pdb64(PDB64 *);


/*******************************/
/*
	Associate Memory
*/
/*******************************/

typedef struct assoc64_index {
	INTEGER64	fofs;
	short		type;
#define AIT_INTEGER	1
#define AIT_STRING	2
	short		name;
} ASSOC64_INDEX;

typedef struct pn64_assoc_header {
	PN64_HEADER	h;
	ASSOC64_INDEX	ix[1];
} PN64_ASSOC_HEADER;

#define PN64_ASSOC_HEADER_S(x)	((int)(&(((PN64_ASSOC_HEADER*)0)->ix[x])))

typedef struct pn64_assoc_data {
	PN64_HEADER	h;
	char		data[1];
} PN64_ASSOC_DATA;

#define PN64_ASSOC_DATA_S(x)	((int)(&(((PN64_ASSOC_DATA*)0)->data[x])))




#endif

