/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___FAVT64_H___
#define ___FAVT64_H___

#include "pdb64.h"

/* FAVT Defined */

#define FAVT64_CACHE_SIZE		10000

#ifndef AVT_E_NO_OBJ 

/* FAVT ERROR CODE */

#define AVT_E_NO_OBJ		(-1)
#define AVT_E_LOAD_ERROR_1	(-2)
#define AVT_E_LOAD_ERROR_2	(-3)
#define AVT_E_BOUND		(-4)

/* FAVT Defined  END */

#endif

#define FAVT_CACHE_SIZE	100

typedef struct favt64_header {
	struct favt64_header *	next;
	struct favt64_header * 	prev;
	PDB64 *			p;
	U_INTEGER64		fofs;
	short			type;
	unsigned short		flags;
#define FAF_DIRTY	0x0001
#define FAF_LOCK	0x0002
} FAVT64_HEADER;

typedef struct favt64_ptr {
	U_INTEGER64		fofs;
	int			type;
	void *			ptr;
	unsigned short		flags;
} FAVT64_PTR;

typedef struct favt64_node {
	FAVT64_HEADER	h;
	FAVT64_PTR	small;
	FAVT64_PTR	large;
	FAVT64_PTR *	parent;
	struct favt64_root * root;
	int		level;
	INTEGER64	data_len;
	void *		data;
} FAVT64_NODE;

typedef struct favt64_root {
	FAVT64_HEADER	h;
	int		type;
	void		(*endian_func)();
	FAVT64_PTR	node;
} FAVT64_ROOT;

typedef struct bound64_list {
	struct bound64_list *	next;
	void *			data;
	INTEGER64		data_len;
} BOUND64_LIST;

FAVT64_ROOT * favt64_alloc_root(PDB64 *,int,void (*)());
FAVT64_NODE * favt64_alloc_node(FAVT64_ROOT *,void *,int);
FAVT64_NODE * 
favt64_insert(int *,FAVT64_ROOT *,FAVT64_PTR *,FAVT64_NODE * ,int (*)(),void *);
FAVT64_NODE * 
favt64_delete(int *,FAVT64_ROOT *,FAVT64_PTR *,void *,int (*)(),void *);
FAVT64_NODE * 
favt64_search(int *,FAVT64_ROOT * p,FAVT64_NODE * a,void * data,int (*cmp)(),void *);
BOUND64_LIST *
favt64_bound_search(
	int *,
	FAVT64_ROOT *,FAVT64_NODE *,void *,void *,int,int (*)(),void *);
void free64_bound_list(BOUND64_LIST *);
FAVT64_ROOT * get_root64(int * ,PDB64 *,U_INTEGER64,void (*)());
void favt64_test(int *,FAVT64_ROOT * p,FAVT64_NODE * a,int (*cmp)());
FAVT64_NODE * root_node64(int *,FAVT64_ROOT * r);
void favt64_free_root(FAVT64_ROOT * rt);
void favt64_free_node(FAVT64_NODE * rt);
int favt64_trace_from_large(int * errp,
	FAVT64_ROOT * p,FAVT64_NODE * a,int (*func)(),void * work);
int favt64_trace_from_small(int * errp,
	FAVT64_ROOT * p,FAVT64_NODE * a,int (*func)(),void * work);
void favt64_lock(FAVT64_HEADER *);
void favt64_unlock(FAVT64_HEADER *);

void check_cache64(char * str) ;
void
flush_favt64_cache(PDB64 * p) ;

void
change_endian_favt64_root(PN64_FAVT_ROOT * r);
void
change_endian_favt64_node(PN64_FAVT_NODE * n);

void init_favt64();

FAVT64_NODE *
l_favt64_alloc_node(FAVT64_ROOT * rt,
	void * data,int data_size);
FAVT64_ROOT *
l_favt64_alloc_root(PDB64 * p,int type,void (*func)());
FAVT64_NODE *
l_favt64_delete(int * errp,FAVT64_ROOT * p,FAVT64_PTR * favtp,void * data,int (*cmp)(),void * w);
void
l_favt64_free_node(FAVT64_NODE * n);
FAVT64_NODE *
l_favt64_insert(int * errp,
	FAVT64_ROOT * p,FAVT64_PTR * favtp,FAVT64_NODE * a,int (*cmp)(),void * w);
FAVT64_NODE *
l_favt64_search(int * errp,
	FAVT64_ROOT * p,FAVT64_NODE * a,void * data,int (*cmp)(),void * w);
int
l_favt64_trace_from_small(int * errp,
		FAVT64_ROOT * p,FAVT64_NODE * a,int (*func)(),void * work);
FAVT64_ROOT *
l_get_root64(int * errp,PDB64 * p,unsigned int fofs,void (*func)());
FAVT64_NODE *
l_root_node64(int * errp,FAVT64_ROOT * r);
void
l_check_cache64(char * str);
int
l_favt64_trace_from_large(int * errp,
		FAVT64_ROOT * p,FAVT64_NODE * a,int (*func)(),void * work);
void
l_flush_favt64_cache(PDB64 * p);
void
l_flush_filespace64(PDB64 * p);
void
l_close_filespace64(PDB64 * p);
BOUND64_LIST *
l_favt64_bound_search(
	int * errp,
	FAVT64_ROOT * p,
	FAVT64_NODE * a,
	void *	data_min,
	void *	data_max,
	int	limit,
	int (*cmp)(),
	void * cw);
void init_l_favt64();


int
l_write_filespace64(PDB64 * p,void * h);
int
l_write_filespace64f(PDB64 * p,U_INTEGER64 fofs,void * h);
void *
l_read_filespace64(PDB64 * p,U_INTEGER64 fofs);
void *
l_read_filespace64_header(PDB64 * p,U_INTEGER64 fofs);
void *
l_read_filespace64f_header(PDB64 * p,U_INTEGER64 fofs);
void *
l_read_filespace64f(PDB64 * p,U_INTEGER64 fofs);
void
l_free_filespace64(PDB64 * p,U_INTEGER64 fofs);
INTEGER64
l_alloc_filespace64(PDB64 * p,PN64_HEADER * h);
void
l_truncate_filespace64(PDB64 * p);


#endif
