/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	"long_char.h"
#include	"memory_debug.h"
#include	"pdb.h"
#include	"pmd.h"
#include	"resource.h"
#include	"lump.h"




void
set_metadata(L_CHAR * db,GB_RECT * minrect,REAL1 reso,
	L_CHAR * crd,RESOURCE * r,
	RESOURCE * db_r,
	unsigned int interval)
{
PMD_WORK w;
PMD_TEMP * t_file, * t_res;
L_CHAR * obj;
int er;
unsigned int fofs;
char * path;
L_CHAR * unit_path;
int len1,len2;
int err_pos;
int e_code;
int e_favt_code;
int ret_er;

log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
"db = %s (%f %f)-(%f %f) %f %s %s\n",
n_string(std_cm,db),
r->h.minrect.tl.x,
r->h.minrect.tl.y,
r->h.minrect.br.x,
r->h.minrect.br.y,
r->h.visible_resolution,
n_string(std_cm,crd),
n_string(std_cm,get_url_str2(&r->h.entry)));


	err_pos = 0;
	if ( r->h.minrect.br.x < r->h.minrect.tl.x )
		return;
	if ( r->h.minrect.br.y < r->h.minrect.tl.y )
		return;
	if ( r->h.type == RT_COORDINATE ) {
		if ( r->h.visible_resolution == 0 )
			return;
		if ( r->h.minrect.br.x - r->h.minrect.tl.x <
				1/r->h.visible_resolution )
			return;
		if ( r->h.minrect.br.y - r->h.minrect.tl.y <
				1/r->h.visible_resolution )
			return;
	}

	t_res = get_temp_resource(r,crd,minrect,reso);
//print_pmd_temp(t_res,"get_temp_resource");
	t_file = 0;
	if ( t_res && t_res->md_list == 0 ) {
		free_temp(t_res);
		t_res = 0;
	}

	er = -1;
	obj = ll_copy_str(get_url_str2(&r->h.entry));

	len1 = l_strlen(db_r->h.cu.system);
	len2 = l_strlen(db_r->h.cu.unit);

	unit_path = d_alloc(sizeof(L_CHAR)*(len1+len2+2));
	memcpy(unit_path,db_r->h.cu.system,
			sizeof(L_CHAR)*len1);
	unit_path[len1] = '?';
	memcpy(&unit_path[len1+1],db_r->h.cu.unit,
			sizeof(L_CHAR)*(1+len2));
	if ( len1+len2+2 > PMD_UNIT_LEN )
		unit_path[PMD_UNIT_LEN-1] = 0;

	w.err = 0;
	open_db(&w,db,unit_path,O_RDWR);

	d_f_ree(unit_path);

	switch ( w.err ) {
	case 0:
		break;
	case -2:
		goto err0;
	default:
		err_pos = 1;
		goto err3;
	}
	w.favt_err = 0;
	fofs = search_db_by_target(&w,crd,obj);
	if ( w.err < 0 ) {
		err_pos = 2;
		goto err3;
	}
	if ( fofs == 0 ) {
		t_file = 0;
	}
	else {
		t_file = get_temp_db(&w,fofs);
		if ( w.err < 0 ) {
			err_pos = 3;
			goto err3;
		}
//print_pmd_temp(t_file,"get_temp_db");
	}
	if ( t_res == 0 ) {
		if ( t_file == 0 ) {
			er = 0;
			err_pos = 4;
			goto err3;
		}
		ret_er = delete_db(&w,t_file);
		if ( w.err < 0 ) {
			err_pos = 5;
			goto err3;
		}
		er = 0;
		err_pos = 6;
		goto err3;
	}
	else if ( t_file == 0 ) {
/*
check_favt_ring();
*/
		t_res->timeout = get_xltime() + interval;
//print_pmd_temp(t_res,"write_temp");
		ret_er = write_temp(&w,t_res,WRITE_TEMP_ALLOC);

		if ( w.err < 0 ) {
			err_pos = 7;
			goto err3;
		}
		ret_er = insert_db(&w,t_res);
		if ( w.err < 0 ) {
			err_pos = 8;
			goto err3;
		}
/*
check_favt_ring();
*/
	}
	else if ( cmp_temp(t_res,t_file) == 0 ) {
		log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
			"PMD_DB CHANGE_TIMEOUT (%s) TIMEOUT BEFORE %i %i\n",
			w.path,t_file->fofs,t_file->timeout);

		change_timeout(&w,t_file,get_xltime() + interval);

		log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
			"PMD_DB CHANGE_TIMEOUT (%s) TIMEOUT AFTER %i %i\n",
			w.path,t_file->fofs,t_file->timeout);

		if ( w.err < 0 ) {
			err_pos = 9;
			goto err3;
		}
	}
	else {
		t_res->timeout = get_xltime() + interval;
/*
ss_printf("before delete %f %f - %f %f\n",
t_file->minrect.tl.x,
t_file->minrect.tl.y,
t_file->minrect.br.x,
t_file->minrect.br.y
);
*/
		ret_er = delete_db(&w,t_file);
		if ( w.err < 0 ) {
			err_pos = 10;
			goto err3;
		}
		ret_er = insert_db(&w,t_res);
		if ( w.err < 0 ) {
			err_pos = 11;
			goto err3;
		}
	}
	er = 0;
err3:
	if ( t_res ) {
		log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
			"PMD_DB T_RES (%s) FOFS %i %i\n",
			w.path,t_res->fofs,t_res->timeout);
		free_temp(t_res);
	}
	if ( t_file ) {
		log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
			"PMD_DB T_FILE (%s) FOFS %i %i\n",
			w.path,t_file->fofs,t_file->timeout);

		free_temp(t_file);
	}
	d_f_ree(obj);
	if ( er ) {
		e_code = w.err;
		e_favt_code = w.favt_err;
		if ( w.path )
			path = copy_str(w.path);
		else	path = 0;
		close_db(&w);
		if ( path ) {
ss_printf("UNLINK %i - %i %i %i\n",er,err_pos,ret_er,w.err);
			log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
				"PMD_DB UNLINK (%s) err_pos = %i (%i / %i)\n",
				path,
				err_pos,
				e_code,
				e_favt_code);
			u_unlink(path);
			d_f_ree(path);
		}
	}
	else {
		delete_timeout_temp(&w);
/*
check_favt_ring();
*/
		close_db(&w);
	}
err0:
	{}
}


