/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"win_flame.h"

//int e2d_p_zoom_etc();

WIN_FLAME_TABLE std_e2d = {
	GT_T_2D>>GT_T_SHIFT,
	WFT_STD,
	e2d_new,
	e2d_move,
	e2d_exit,
	e2d_change,
	e2d_redraw,
	e2d_dirty,
	e2d_overlay,
	e2d_zoom,
	e2d_resize,
	e2d_rotate,
	0,
	e2d_setup_drawrect
};


WIN_FLAME_TABLE e2d_small = {
	GT_T_2D>>GT_T_SHIFT,
	WFT_SMALL,
	e2d_new,
	e2ds_move,
	e2d_exit,
	e2ds_change,
	e2ds_redraw,
	e2ds_dirty,
	e2ds_overlay,
	e2ds_zoom,
	e2ds_resize,
	e2ds_rotate,
	e2ds_get_weight,
	e2ds_setup_drawrect,
};


WIN_FLAME_TABLE e2d_plot = {
	GT_T_2D>>GT_T_SHIFT,
	WFT_PLOT,
	e2d_new,
	e2d_p_move,
	e2d_p_exit,
	e2d_p_change,
	e2d_p_redraw,
	e2d_p_dirty,
	0,
	(f_zoom_type)e2d_p_zoom_etc,
	(f_resize_type)e2d_p_zoom_etc,
	(f_rotate_type)e2d_p_zoom_etc,
	0,
	e2d_setup_drawrect
};

WIN_FLAME_TABLE std_globe = {
	GT_T_GLOBE_SUR>>GT_T_SHIFT,
	WFT_STD,
	e2d_new,
	globe_move,
	e2d_exit,
	e2d_change,
	e2d_redraw,
	e2d_dirty,
	e2d_overlay,
	e2d_zoom,
	e2d_resize,
	e2d_rotate,
	0,
	e2d_setup_drawrect
};

WIN_FLAME_TABLE std_globe_small = {
	GT_T_GLOBE_SUR>>GT_T_SHIFT,
	WFT_SMALL,
	e2d_new,
	globe_small_move,
	e2d_exit,
	e2ds_change,
	e2ds_redraw,
	e2ds_dirty,
	e2ds_overlay,
	e2ds_zoom,
	e2ds_resize,
	e2ds_rotate,
	e2ds_get_weight,
	e2ds_setup_drawrect
};

WIN_FLAME_TABLE globe_plot = {
	GT_T_GLOBE_SUR>>GT_T_SHIFT,
	WFT_PLOT,
	e2d_new,
	globe_move_plot,
	e2d_p_exit,
	e2d_p_change,
	e2d_p_redraw,
	e2d_p_dirty,
	0,
	(f_zoom_type)e2d_p_zoom_etc,
	(f_resize_type)e2d_p_zoom_etc,
	(f_rotate_type)e2d_p_zoom_etc,
	0,
	e2d_setup_drawrect
};


WIN_FLAME_TABLE * wf_geo_type_list[GT_T_MAX][WFT_MAX] = {
	{0,0,0,0},
	{		/* GT_T_2D */
		0,
		&std_e2d,
		&e2d_plot,
		&e2d_small
	},
	{		/* GT_T_GLOBE_SUR */
		0,
		&std_globe,
		&globe_plot,
		&std_globe_small
	}
};


