/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"change_endian.h"
#include	"gbs_trailer.h"
#include	"utils.h"


static void
change_endian_s_p2d_trailer_to_net(P2D_S_TRAILER * t)
{
int i;
int pnos;
	pnos = t->pnos;
	change_endian_s(t->line_id);
	change_endian_s(t->padding_id);
	change_endian_s(t->pnos);
	change_endian_i(t->code);
	for ( i = 0 ; i < pnos ; i ++ ) {
		change_endian_gb_point_f(&t->p[i].p);
		change_endian_s(t->p[i].no);
	}
}

static void
change_endian_l_p2d_trailer_to_net(P2D_L_TRAILER * t)
{
int i;
int pnos;
	pnos = t->pnos;
	change_endian_s(t->line_id);
	change_endian_s(t->padding_id);
	change_endian_i(t->pnos);
	change_endian_i(t->code);
	for ( i = 0 ; i < pnos ; i ++ ) {
		change_endian_gb_point_f(&t->p[i].p);
		change_endian_i(t->p[i].no);
	}
}

void
change_endian_col_trailer(P2D_COL_TRAILER * t)
{
	change_endian_s(t->id);
	change_endian_gb_color(&t->col);
}

void
change_endian_trailer_to_net(TRAILER * t)
{
	switch ( t->t_type ) {
	case TT_COLOR:
		change_endian_col_trailer(&t->c);
		break;
	case TT_P2D:
		change_endian_s_p2d_trailer_to_net(&t->d_s);
		break;
	case TT_L_P2D:
		change_endian_l_p2d_trailer_to_net(&t->d_l);
		break;
	default:
		er_panic("change_endian_trailer_to_net");
	}
}

static void
change_endian_s_p2d_trailer_to_host(P2D_S_TRAILER * t)
{
int i;
int pnos;
	change_endian_s(t->line_id);
	change_endian_s(t->padding_id);
	change_endian_s(t->pnos);
	change_endian_i(t->code);
	pnos = t->pnos;
	for ( i = 0 ; i < pnos ; i ++ ) {
		change_endian_gb_point_f(&t->p[i].p);
		change_endian_s(t->p[i].no);
	}
}

static void
change_endian_l_p2d_trailer_to_host(P2D_L_TRAILER * t)
{
int i;
int pnos;
	change_endian_s(t->line_id);
	change_endian_s(t->padding_id);
	change_endian_i(t->pnos);
	change_endian_i(t->code);
	pnos = t->pnos;
	for ( i = 0 ; i < pnos ; i ++ ) {
		change_endian_gb_point_f(&t->p[i].p);
		change_endian_i(t->p[i].no);
	}
}

void
change_endian_trailer_to_host(TRAILER * t)
{
	switch ( t->t_type ) {
	case TT_COLOR:
		change_endian_col_trailer(&t->c);
		break;
	case TT_P2D:
		change_endian_s_p2d_trailer_to_host(&t->d_s);
		break;
	case TT_L_P2D:
		change_endian_l_p2d_trailer_to_host(&t->d_l);
		break;
	default:
		er_panic("change_endian_trailer_to_net");
	}
}


void
get_s_p2d_trailer(P2D_T_SET * set)
{
	set->size = P2D_TRAILER_S_PT_SIZE(set->trailer->d_s.pnos);
	set->next = (TRAILER*)&set->trailer->d_s.p[set->trailer->d_s.pnos];
}

void
get_l_p2d_trailer(P2D_T_SET * set)
{
	set->size = P2D_TRAILER_L_PT_SIZE(set->trailer->d_l.pnos);
	set->next = (TRAILER*)&set->trailer->d_l.p[set->trailer->d_l.pnos];
}

void
get_col_trailer(P2D_T_SET * set)
{
	set->size = sizeof(P2D_COL_TRAILER);
	set->next = (TRAILER*)((&set->trailer->c)+1);
}

void
get_trailer(P2D_T_SET * set)
{
	switch ( set->trailer->t_type ) {
	case TT_COLOR:
		get_col_trailer(set);
		break;
	case TT_P2D:
		get_s_p2d_trailer(set);
		break;
	case TT_L_P2D:
		get_l_p2d_trailer(set);
		break;
	}
}

void
set_s_p2d_trailer(P2D_T_SET * set,int pnos)
{
	set->size = P2D_TRAILER_S_PT_SIZE(pnos);
	if ( set->trailer ) {
		set->next = (TRAILER*)&set->trailer->d_s.p[pnos];
	}
}

void
set_l_p2d_trailer(P2D_T_SET * set,int pnos)
{
	set->size = P2D_TRAILER_L_PT_SIZE(pnos);
	if ( set->trailer ) {
		set->next = (TRAILER*)&set->trailer->d_l.p[pnos];
	}
}


