/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	"xl.h"
#include	"pri_level.h"
#include	"rcache.h"
#include	"memory_debug.h"
#include	"gbview.h"
#include	"win_flame.h"
#include	"cosmos.h"
#include	"init.h"
#include	"save_global.h"
#include	"ex_utils.h"
#include	"http.h"
#include	"HTMLDB.h"
#include	"matrix.h"
#include	"xldir.h"
#include	"heuristics_win_frame.h"

#include	"v/v.h"
#include	"v/vobj_utils.h"
#include	"fa_cache.h"

void v_loop_init();
void main_task();
void stop_loop();
void quit_task();
XL_SEXP *
xl_gv_sync(
	XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);

void
v_loop_init()
{
XL_INTERPRETER * xli;
	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);
}

void
init_main()
{
	set_env(gblisp_top_env0,l_string(std_cm,"gv-sync"),
		get_func_prim(xl_gv_sync,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_gv_sync(
	XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{

printf("============== gv-syn\n");
	wait_initialize();
	if ( wf_next_gf(0,GVFM_LIVE) == 0 ) {
		call_window_function("main-window");
	}
	return 0;
}




void
main_task()
{
XL_INTERPRETER * xli;
	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	loading_file(0, l_string(std_cm,"local"), 1);

//		if ( view_agent_switch == 0 )
//			start_gbview();

	call_window_function("main-window");

	finish_initialize();
}



void stop_loop()
{
  for ( ; ; )
    sleep_sec(1);
}


int
_main(int argc,char ** argv)
{

	if ( argc < 2 ) {
		fprintf(stderr,"too few argment\n");
		exit(1);
	}
	if ( strcmp(argv[1],"v") == 0 ) {
// OK
		start_alloc_time_list();

		tick_start_lock();

		init_sg();

		view_init(argc,argv);
// unlock NG

		init_ex_language(gblisp_top_env1);
// unlock NG
/*
{
char * a;
	a = d_alloc(100);
	d_f_ree(a);
	a[10] = 0;
}
*/
		vobject_init_gb(&argc, &argv);
		init_vobj_function_gb();
// unlock NG 		
		vobject_quit_callback = client_quit;

		init_http_server();
		init_polling_class(gblisp_top_env0);
		init_html_db();
// unlock NG
		fac_general_info.total_entries = 256*256*2/FAC_SIZE;

		init_main();
// unlock NG
		set_rcache_dir_path(
			l_string(std_cm,get_preference_path()),
			l_string(std_cm,"cache"));
// unlock NG

		enable_rcache(RCF_ALL);
// unlock NG
		open_control_port();

		create_task((void(*)(TKEY))main_task,0,PRI_FETCH);

		end_sg();
// OK
		tick_start_unlock();

// NG
		event_task();
	}
	else if ( strcmp(argv[1],"i") == 0 ||
		  strcmp(argv[1],"o") == 0 ) {
		if ( argc < 3 ) {
			fprintf(stderr,"too few argment\n");
			exit(1);
		}
		ipc_init(argc,argv);
		ipc_system(argc,argv);
	}
	else {
		fprintf(stderr,"invalid argment %s\n",
			argv[1]);
		exit(1);
	}
	exit(0);
	return 0;
}

static int quit_flag = 0;

int
client_quit()
{
	switch ( quit_flag ) {
	case 2:
		return 1;
	case 1:
		return 0;
	case 0:
		quit_flag = 1;
		create_task((void(*)(TKEY))quit_task,0,PRI_QUIT);
		return 0;	// stop vobject_quit
	}
	return 0;
}

void
quit_task()
{
/*
bool vobject_quit();
*/
XL_INTERPRETER * xli;
void VgbFlame_save_preference_wpm();

	reset_modal_flag(0);
	create_task((void(*)(TKEY))modal_quit_task,0,PRI_QUIT);
	reset_modal_flag(1);

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);
	
	s_shutdown_stream(STT_NET);

	VgbFlame_save_preference_wpm();
	rcache_stop();
	disable_rcache();
	close_hwf();
	
	close_all_matrix();
	quit_flag = 2;
	vobject_quit();
}


