/**********************************************************************
 *
 * Copyright (C) 2003-2004
 * Hirohisa MORI <joshua@nichibun.ac.jp>
 * Masaki MIDORIKAWA <greenrev@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GLOBALBASE
 * Library General Public License (G-LGPL) as published by
 *
 * http://www.globalbase.org/
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * **********************************************************************/

#include "xl.h"
#include "xlerror.h"
#include "utils.h"
#include "memory_debug.h"

extern XL_SEXP * get_pathpair();
XL_SEXP * xl_GetXLpathpair();

void
init_GetXLpathpair(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetXLpathpair"),
		get_func_prim(xl_GetXLpathpair,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_GetXLpathpair(XLISP_ENV * env,XL_SEXP * s)
{
	XL_SEXP * cur;
	cur = get_el(s,1);
	return get_pathpair(cur->string.data);
}
