/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VSplitView.h"
#include "v/vobj_utils.h"

extern "C" {
#include "xl.h"
#include "xlerror.h"

XL_SEXP * vobj_VSplitView(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);
XL_SEXP * vobj_ShowChild(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);

XL_SEXP *
vobj_VSplitView(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
	XL_SEXP * _ref;
	VSplitView *obj;
	VObjectStatus sts;
	XL_SEXP *cmd = get_el(arg, 0);

	sts.attr = 0;
	short def_size[2] = {-1,-1};

	L_CHAR *attr;
	if ( ( attr = get_sf_attribute(sf, l_string(std_cm, "def_size")) ) )
		sscanf(n_string(std_cm,attr), "%hd,%hd", def_size, def_size+1);
	if ( ( attr = get_sf_attribute(sf, l_string(std_cm, "shrinkable0")) ) )
		if ( atoi(n_string(std_cm,attr)) )
			sts.attr |= VSplitView::shrinkable0;
	if ( ( attr = get_sf_attribute(sf, l_string(std_cm, "shrinkable1")) ) )
		if ( atoi(n_string(std_cm,attr)) )
			sts.attr |= VSplitView::shrinkable1;
	if ( ( attr = get_sf_attribute(sf, l_string(std_cm, "on_resize")) ) ) {
		if ( l_strcmp(attr, l_string(std_cm, "expand0")) == 0 )
			sts.attr |= VSplitView::expand0_on_resize;
		else if ( l_strcmp(attr, l_string(std_cm, "expand1")) == 0 )
			sts.attr |= VSplitView::expand1_on_resize;
	}

	if ( get_type(cmd) == XLT_SYMBOL && 
			l_strcmp(cmd->symbol.data, l_string(std_cm, "VHSplitView")) == 0 )
		_ref = get_refered_object<VHSplitView>
				((VHSplitView**)&obj,env,arg,sf,VO_HGRV,"VHSplitView",&sts,VSF_ATTR,def_size);
	else	_ref = get_refered_object<VVSplitView>
				((VVSplitView**)&obj,env,arg,sf,VO_VGRV,"VVSplitView",&sts,VSF_ATTR,def_size);
	if ( get_type(_ref) != XLT_INTEGER )
		return _ref;

	obj->get_status(&sts, VSF_ID);
	XL_SEXP *ret = vobj_eval_child(sts.id, env, arg);
	if ( get_type(ret) == XLT_ERROR )
		return ret;
	switch ( get_type(_ref) ) {
	case XLT_INTEGER:
		return vobj_get_id_list(_ref->integer.data,ret,sf,0);
	case XLT_ERROR:
		return _ref;
	}
	return vobj_get_id_list(sts.id, ret, sf,0);
}

XL_SEXP *
vobj_ShowChild(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
	XL_SEXP *cmd = get_el(arg, 0);
	XL_SEXP *target = get_el(arg, 1);
	XL_SEXP *child = get_el(arg, 2);
	XL_SEXP *expand = get_el(arg, 3);
	if ( get_type(target) != XLT_INTEGER || get_type(child) != XLT_INTEGER ||
				get_type(expand) != XLT_INTEGER )
		return get_error(
			arg->h.file,
			arg->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"ShowChild"),
			n_get_string("type missmatch"));
	VSplitView *obj = dynamic_cast<VSplitView*>(
		VObject::get_object_by_id(target->integer.data));
	if ( obj == 0 )
		return vobj_get_error(initial_VExError(V_ER_NOT_FOUND,0,0), arg,0);
	
	if ( l_strcmp(cmd->symbol.data, l_string(std_cm, "ShowChild")) == 0 )
		obj->show_pane(child->integer.data, expand->integer.data);
	else
		obj->hide_pane(child->integer.data, expand->integer.data);
	return 0;
}

void
init_VSplitView(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VHSplitView"),
		get_func_prim((XL_SEXP*(*)())vobj_VSplitView,FO_NORMAL,0,3,3));
	set_env(env,l_string(std_cm,"VVSplitView"),
		get_func_prim((XL_SEXP*(*)())vobj_VSplitView,FO_NORMAL,0,3,3));

	set_env(env,l_string(std_cm,"ShowChild"),
		get_func_prim((XL_SEXP*(*)())vobj_ShowChild,FO_APPLICATIVE,0,4,4));
	set_env(env,l_string(std_cm,"HideChild"),
		get_func_prim((XL_SEXP*(*)())vobj_ShowChild,FO_APPLICATIVE,0,4,4));
}


} // extern "C"
