/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"acrp.h"
#include	"gb.h"
#include	"mx.h"

XL_SEXP * xl_Get();
XL_SEXP * gb_gmxGet();
XL_SEXP * get_op();


#define MODE_DATA	0
#define MODE_META	1
#define MODE_MPT	2
#define MODE_LUMP	3
#define MODE_CHILDREN	4
#define MODE_PARENT	5

void
init_gmxGet(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Get"),
		get_func_prim(gb_gmxGet,FO_APPLICATIVE,0,2,3));
}



XL_SEXP *
open_mxread_server_related(L_CHAR * file,XL_SEXP * s)
{
L_CHAR * fn;
L_CHAR * target[2];
MX_ENTRY * e;
XL_SEXP * ret;
XL_GETFILE * gf;
int i;
MATRIX_NODE * n;
int err;
XL_SEXP * dim_code;
INTEGER64 * _dim_code;
	ret = 0;
	_dim_code = 0;

	fn = nl_copy_str(std_cm,"Get");
	target[0] = target[1] = 0;
	ret = get_path(target,&gf,file,s,fn);
	if ( get_type(ret) == XLT_ERROR )
		goto end;
	d_f_ree(fn);
	if ( l_strcmp(gf->mode,l_string(std_cm,"lod")) ) {
		ret = get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNSUPPORT_MODE,
			l_string(std_cm,"Get(gbmx)"),
			n_get_string("unsupport Get mode"));
		goto end;
	}
	dim_code = get_el(s,2);
	if ( get_type(dim_code) != XLT_PAIR ) {
		ret = get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"Get(gbmx)"),
			n_get_string("dim_code"));
		goto end;
	}

	for ( i = 0 ; i < 2 ; i ++ ) {
		if ( target[i] == 0 )
			break;

		e = open_mxread(0,target[i],0,MI_MODE_SERVER);
		if ( e == 0 )
			continue;
		_dim_code = get_dim_code_from_sexp(e->c.m,dim_code);
		if ( _dim_code == 0 ) {
			ret = get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"Get(gbmx)"),
				n_get_string("dim_code format"));
			goto end;
		}
		err = 0;
		n = get_matrix_node(&err,e->c.m,_dim_code,GN_ERROR_NORETRY,0,&ret);
		switch ( err ) {
		case ME_MATRIX_ERR:
			ret = get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_OPEN_FILE,
				l_string(std_cm,"Get(gbmx)"),
				List(n_get_string("get_matrix error"),get_integer(err,0),-1));
			break;
		case ME_ERR_NODE:
		case ME_NO_NODE:
			ret = get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_OBJECT,
				l_string(std_cm,"Get(gbmx)"),
				List(n_get_string("get_matrix there is no node"),dim_code,-1));
			break;
		case ME_PROC_NODE:
			unlock_node(n,0);
			break;
		case 0:
			ret = encode_matrix_node(n);
			unlock_node(n,0);
			break;
		default:
			er_panic("????");
		}

		goto end;
	}
	if ( i == 2 ) {
		ret = get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_OPEN_FILE,
			l_string(std_cm,"Get(gbmx)"),
			0);
	}
end:
	if ( _dim_code )
		d_f_ree(_dim_code);
	if ( target[0] )
		d_f_ree(target[0]);
	if ( target[1] )
		d_f_ree(target[1]);
	return ret;
}

XL_SEXP *
gb_gmxGet(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
XL_SEXP * ret;
L_CHAR * mode;
XL_SEXP * filename;
char * e_msg;
	filename = get_el(s,1);
	e_msg = "filename";
	if ( get_type(filename) != XLT_STRING )
		goto type_missmatch;
	e_msg = "mode value";
	mode = get_sf_attribute(sf,l_string(std_cm,"mode"));
	if ( mode == 0 ) {
	data_read:
		ret = open_mxread_server_related(filename->string.data,s);
	}
	else if ( l_strcmp(mode,l_string(std_cm,"data")) == 0 ) {
		goto data_read;
	}
	else if ( l_strcmp(mode,l_string(std_cm,"meta")) == 0 ) {
		ret = open_status_related(0,filename->string.data,s);
	}
	else goto inv_param;

	return ret;
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Get(gbmx)"),
		n_get_string(e_msg));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Get(gbmx)"),
		n_get_string(e_msg));
}

