/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbgraph.h"

int
inside_triangle(GB_POINT ptp[3],GB_POINT p)
{
GB_POINT q,q1,q2;
REAL1 d,u1,u2,u;
	q = p_sub(p,ptp[0]);
	q1 = p_sub(ptp[1],ptp[0]);
	q2 = p_sub(ptp[2],ptp[0]);
	d = q2.x*q1.y - q2.y*q1.x;
	if ( d == 0 ) {
		if ( q.x*q1.y - q.y*q1.x == 0 )
			return 0;
		return -1;
	}
	u1 = (q.x*q1.y - q.y*q1.x)/d;
	u2 = (q2.x*q.y - q2.y*q.x)/d;
	u = u1+u2;
	if ( u1 < 0 )
		return -1;
	if ( u2 < 0 )
		return -1;
	if ( u > 1 )
		return -1;
	return 0;
}

int
inside_triangle_arg(GB_INS_TRG_WORK * w,GB_POINT ptp[3],GB_POINT p)
{
GB_POINT q,q1,q2;
REAL1 d,u1,u2,u;
REAL1 rev_d;
	q = p_sub(p,ptp[0]);
	if ( w->fg == 0 ) {
		q1 = p_sub(ptp[1],ptp[0]);
		q2 = p_sub(ptp[2],ptp[0]);
		d = q2.x*q1.y - q2.y*q1.x;
		
		w->q1 = q1;
		w->q2 = q2;
		w->d = d;
		w->fg = 1;
		
		if ( d == 0 ) {
			if ( q.x*q1.y - q.y*q1.x == 0 )
				return 0;
			return -1;
		}
		else {
			rev_d = 1/d;

			w->q1.x *= rev_d;
			w->q1.y *= rev_d;
			w->q2.x *= rev_d;
			w->q2.y *= rev_d;
		}
		
		u1 = (q.x*q1.y - q.y*q1.x)*rev_d;
		u2 = (q2.x*q.y - q2.y*q.x)*rev_d;
		u = u1+u2;
		if ( u1 < 0 )
			return -1;
		if ( u2 < 0 )
			return -1;
		if ( u > 1 )
			return -1;
		return 0;
	}
	else {
		q1 = w->q1;
		q2 = w->q2;
		d = w->d;

		if ( d == 0 ) {
			if ( q.x*q1.y - q.y*q1.x == 0 )
				return 0;
			return -1;
		}

		u1 = (q.x*q1.y - q.y*q1.x);
		u2 = (q2.x*q.y - q2.y*q.x);
		u = u1+u2;
		if ( u1 < 0 )
			return -1;
		if ( u2 < 0 )
			return -1;
		if ( u > 1 )
			return -1;
		return 0;
	}
}
