/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<sys/types.h>
#include	<sys/wait.h>
#include	<signal.h>
#include	<errno.h>
#include	"utils.h"
#include	"task.h"
#include	"machine/err.h"

int stab[2];
extern int ignore_child_flag;

void
exit_stabilizer(char ch)
{
	write(stab[1],&ch,1);
	close(stab[1]);
}

int
stabilizer()
{
char ch;
int ret;
int id;
int er;

	all_signal_mask_posix();
	set_ignore_chld();
	ret = 's';
	close(0);
	close(1);
	close(2);
	for ( ; ; ) {
		pipe(stab);
		id = fork();
		if ( id == 0 ) {
			/* children */
			close(stab[0]);
			return ret;
		}
		close(stab[1]);
	retry:
		if ( (er=read(stab[0],&ch,1)) == 1 ) {
			switch ( ch ) {
			case 'e':
				close(stab[0]);
				if ( ignore_child_flag ) {
					for ( ; ; ) {
				    		if ( wait(0) < 0 )
							break;
					}
				}
				exit(0);
			default:
				ret = ch;
			}
		}
		else {
			if ( er < 0 ) {
				switch ( errno ) {
				case ESYS_AGAIN:
				case ESYS_INTR:
					goto retry;
				}
			}
			ret = 'a'; /* abort */
		}
		close(stab[0]);
		if ( ignore_child_flag ) {
			for ( ; ; ) {
				if ( wait(0) < 0 )
					break;
			}
		}
	}
}
