/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


// ===========================================================================
//	CDataBrowserImp.cp                             2004.3.16   Tomoki Sekiyama
// ===========================================================================

#ifdef PowerPlant_PCH
	#include PowerPlant_PCH
#endif

#include "PP_Prefix.h"
#include "UException.h"
#include "ControlDefinitions.h"
#include "CDataBrowserImp.h"

PP_Begin_Namespace_PowerPlant


// ---------------------------------------------------------------------------
//  Static Member Variable
// ---------------------------------------------------------------------------

DataBrowserCallbacks CDataBrowserImp::sCallbacks;
bool CDataBrowserImp::sCallbacksInited = 0;

pascal ControlKeyFilterResult
CDataBrowserControlKeyFilterFunc(
   ControlRef theControl,
   SInt16 * keyCode,
   SInt16 * charCode,
   EventModifiers * modifiers);


pascal ControlKeyFilterResult
CDataBrowserControlKeyFilterFunc(
   ControlRef theControl,
   SInt16 * keyCode,
   SInt16 * charCode,
   EventModifiers * modifiers)
{
	if (*modifiers & cmdKey) {
		CDataBrowser *pane = (CDataBrowser*)::GetControlReference(theControl);
		pane->reservedEvent.what = keyDown;
		pane->reservedEvent.message = *charCode | *keyCode;
		pane->reservedEvent.when = ::TickCount();
		pane->reservedEvent.modifiers = *modifiers;
		pane->dispatch_flag = true;

		return kControlKeyFilterBlockKey;
	}
	return kControlKeyFilterPassKey;
}

static ControlKeyFilterUPP	CDataBrowserControlKeyFilterUPP 
			= NewControlKeyFilterUPP(CDataBrowserControlKeyFilterFunc);


// ---------------------------------------------------------------------------
//	 CDataBrowserImp					Stream/Default Constructor	  [public]
// ---------------------------------------------------------------------------
//	Do not access inStream. It may be nil. Read Stream data in Init()

CDataBrowserImp::CDataBrowserImp(
	LStream*	inStream)

	: LAMControlImp(inStream)
{
}


// ---------------------------------------------------------------------------
//	 ~CDataBrowserImp						Destructor				  [public]
// ---------------------------------------------------------------------------

CDataBrowserImp::~CDataBrowserImp()
{
}


// ---------------------------------------------------------------------------
//	 MakeMacControl											   [protected]
// ---------------------------------------------------------------------------

void
CDataBrowserImp::MakeMacControl(
	ConstStringPtr	/*inTitle*/,
	SInt32			/*inRefCon*/)
{
	Rect	frame;					// Get Frame in Local coordinates
	if (!CalcLocalFrameRect(frame)) {
		SDimension16	frameSize;
		mControlPane->GetFrameSize(frameSize);

		::MacSetRect(&frame, 0, 0, frameSize.width, frameSize.height);
	}

	StFocusAndClipIfHidden	focus(mControlPane);
	
	WindowPtr		macWindowP = mControlPane->GetMacWindow();
	if (macWindowP == nil) {
		macWindowP = UQDGlobals::GetCurrentWindowPort();
	}

									// Check if there is a root control
	ControlHandle	rootControl;

	OSErr	err = ::GetRootControl(macWindowP, &rootControl);

	if (err == errNoRootControl) {
		err = ::CreateRootControl(macWindowP, &rootControl);
		ThrowIfOSErr_(err);
	}


	err = ::CreateDataBrowserControl(macWindowP, &frame,
									 kDataBrowserListView,
									 &mMacControlH);
	ThrowIfOSErr_(err);

	::SetControlReference(mMacControlH, (SInt32)mControlPane);
	::DeactivateControl(mMacControlH);
	::SetControlData(mMacControlH, kControlDataBrowserPart,
					 kControlDataBrowserKeyFilterTag,
					 sizeof(ControlKeyFilterUPP), &CDataBrowserControlKeyFilterUPP);

	if (! sCallbacksInited) {
		InitDataBrowserCallbacks(&sCallbacks);
		sCallbacks.u.v1.itemDataCallback = 
			NewDataBrowserItemDataUPP(CDataBrowser::ItemDataProc);
		sCallbacks.u.v1.itemNotificationCallback = 
			NewDataBrowserItemNotificationUPP(CDataBrowser::ItemNotificationProc);
	}
	SetDataBrowserCallbacks(mMacControlH, &sCallbacks);
	
	if (mTextTraitsID != 0) {				// Use custom text traits
		ResIDT	saveID = mTextTraitsID;		// Save and set member var to 0
		mTextTraitsID = 0;					//   so SetTextTraits() knows
		SetTextTraitsID(saveID);			//   the value is changing
	}
}


// ---------------------------------------------------------------------------
//	 ResizeFrameBy													  [public]
// ---------------------------------------------------------------------------

void
CDataBrowserImp::ResizeFrameBy(
	SInt16			inWidthDelta,
	SInt16			inHeightDelta)
{
	LAMControlImp::ResizeFrameBy(inWidthDelta, inHeightDelta);
	::AutoSizeDataBrowserListViewColumns(mMacControlH);
}


// ---------------------------------------------------------------------------
//	 AdjustControlBounds										   [protected]
// ---------------------------------------------------------------------------

void
CDataBrowserImp::AdjustControlBounds(
	Rect&	ioBounds)
{
	if (static_cast<CDataBrowser*>(mControlPane)->mDrawFocusRing)
		::MacInsetRect(&ioBounds, -3, -3);
}


PP_End_Namespace_PowerPlant
