// ===========================================================================
//	LTableSingleSelector.h		PowerPlant 2.2.1	1995-2001 Metrowerks Inc.
// ===========================================================================
//
//	Manages the selection for a TableView than can have only one selected cell

#ifndef _H_LTableSingleSelector
#define _H_LTableSingleSelector
#pragma once

#include <UTableHelpers.h>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant

// ---------------------------------------------------------------------------

class	LTableSingleSelector : public LTableSelector {
public:
						LTableSingleSelector( LTableView* inTableView );
								
	virtual				~LTableSingleSelector();

	virtual Boolean		CellIsSelected( const STableCell& inCell ) const;
	
	virtual	STableCell	GetFirstSelectedCell() const;
	
	virtual	TableIndexT	GetFirstSelectedRow() const;
	
	virtual void		SelectCell( const STableCell& inCell );
	
	virtual void		SelectAllCells();
	
	virtual void		UnselectCell( const STableCell& inCell );
								
	virtual void		UnselectAllCells();

	virtual void		ClickSelect(
								const STableCell&		inCell,
								const SMouseDownEvent&	inMouseDown);
								
	virtual Boolean		DragSelect(
								const STableCell&		inCell,
								const SMouseDownEvent&	inMouseDown);

	virtual void		InsertRows(
								UInt32					inHowMany,
								TableIndexT				inAfterRow);
								
	virtual void		InsertCols(
								UInt32					inHowMany,
								TableIndexT				inAfterCol);
								
	virtual void		RemoveRows(
								UInt32					inHowMany,
								TableIndexT				inFromRow);
								
	virtual void		RemoveCols(
								UInt32					inHowMany,
								TableIndexT				inFromCol);

protected:
	STableCell		mSelectedCell;
};

PP_End_Namespace_PowerPlant


#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif
