/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VDisplay.h"
#include "v/v.h"
#include "v/VClipboard.h"

extern "C" {

int vobject_init_m1(int *argc, char ***argv);
int vobject_init_m2(int *argc, char ***argv);

void init_v_queue();
void v_register_class();


void
v_register_class()
{
	VRegisterClass(VDisplay);
	VRegisterClass(VWindow);
	VRegisterClass(VVAlignView);
	VRegisterClass(VHAlignView);
	VRegisterClass(VTableView);
	VRegisterClass(VDraw);
	VRegisterClass(VexDraw);
	VRegisterClass(VCheckBox);
	VRegisterClass(VPushButton);
	VRegisterClass(VRadioButton);
	VRegisterClass(VPopupButton);
	VRegisterClass(VScrollView);
	VRegisterClass(VSlider);
	VRegisterClass(VStaticText);
	VRegisterClass(VEditText);
	VRegisterClass(VVSeparator);
	VRegisterClass(VHSeparator);
	VRegisterClass(VGroupBox);
	VRegisterClass(VTabView);
	VRegisterClass(VTreeView);
	VRegisterClass(VProgressBar);
}

int _vobject_init(int *argc, char ***argv,
	INIT_FUNC_LIST * flist)
{
	vobject_init_m1(argc, argv);
	
	v_register_class();
	
	init_v_queue();
	init_clipboard();
	VObject::init();
	if ( flist )
		(*flist->func)(argc,argv,flist->next);
	VDisplay::create();
	
	return vobject_init_m2(argc, argv);
}

int vobject_init(int * argc,char *** argv)
{
	return _vobject_init(argc,argv,0);
}


} // extern "C"

