/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"

#include "vpf_file.h"
#include "vpf_variable_length_index.h"
#include "vpf_types.h"


// VARIABLE_LENGTH_INDEX_FILE
VARIABLE_LENGTH_INDEX_FILE *variable_length_index_file_new(){
	VARIABLE_LENGTH_INDEX_FILE *f;
	f = (VARIABLE_LENGTH_INDEX_FILE *)calloc(sizeof(VARIABLE_LENGTH_INDEX_FILE),1);
	return f;
}

void variable_length_index_file_delete(VARIABLE_LENGTH_INDEX_FILE *i){
	if(i==NULL)
		return;
	if(i->records)
		vpf_list_delete(i->records);
	free(i);
}

int variable_length_index_file_load(VARIABLE_LENGTH_INDEX_FILE *ret, const char *filename){
FILE *fp;
LONG n;
int i;
VPF_LIST *indexs;
VARIABLE_LENGTH_INDEX_RECORD *index;

	fp = fopen(filename, "rb");
	if(fp==NULL){
		printf("error: cannt open file %s\n", filename);
		return FALSE;
	}
	ret->header.number_of_entries = vpf_read_long(fp);
	ret->header.vpf_table_header_size = vpf_read_long(fp);
	
	n = ret->header.number_of_entries;
	
	indexs = vpf_list_new((vpf_list_data_destructor_type)vpf_coordinate_delete);
	for(i=0; i<n; ++i){
		index = variable_length_index_record_new();
		index->offset = vpf_read_long(fp);
		index->size = vpf_read_long(fp);
		vpf_list_push(indexs, index);
	}
	ret->records = indexs;
	fclose(fp);
	return TRUE;
}

VARIABLE_LENGTH_INDEX_RECORD *variable_length_index_record_new()
{
	return (VARIABLE_LENGTH_INDEX_RECORD *)calloc(sizeof(VARIABLE_LENGTH_INDEX_RECORD),1);
}

void variable_index_index_record_delete(VARIABLE_LENGTH_INDEX_RECORD *r)
{
	free(r);
}
