/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_init.h"
#include "vpf_node.h"
#include "vpf_face.h"
#include "vpf_edge.h"
#include "vpf_ring.h"
#include "data_quality_table.h"
#include "vpf_geographic_reference_table.h"
#include "vpf_coverage_attribute_table.h"
#include "vpf_feature_class_schema_table.h"

#include "gm_tileref_aft.h"
#include "gm_coast_line_lft.h"
#include "gm_road_lft.h"
#include "gm_railroad_lft.h"
#include "gm_political_boundary_aft.h"
#include "gm_oceansea_aft.h"
#include "gm_water_course_lft.h"
#include "gm_inland_water_aft.h"
#include "gm_builtup_area_aft.h"
#include "gm_builtup_area_pft.h"

VPF_TABLE_FUNCS *get_table_funcs(VPF_TABLE_TYPE type)
{
	static VPF_TABLE_FUNCS table_funcs_list[] =
	{
		{VTT_NODE,               (read_record_func_type)node_record_read,         (delete_record_func_type)node_record_delete},
		{VTT_EDGE,               (read_record_func_type)edge_record_read,         (delete_record_func_type)edge_record_delete},
		{VTT_RING,               (read_record_func_type)ring_record_read,         (delete_record_func_type)ring_record_delete},
		{VTT_FACE,               (read_record_func_type)face_record_read,         (delete_record_func_type)face_record_delete},
		{VTT_DATA_QUALITY,       (read_record_func_type)data_quality_record_read, (delete_record_func_type)data_quality_record_delete},
		{VTT_COVERAGE_ATTRIBUTE,   (read_record_func_type)coverage_attribute_read, (delete_record_func_type)coverage_attribute_delete},
		{VTT_GEOGRAPHIC_REFERENCE, (read_record_func_type)geographic_reference_record_read,  (delete_record_func_type)geographic_reference_record_delete},
		{VTT_FEATURE_CLASS_SCHEMA, (read_record_func_type)feature_class_schema_read, (delete_record_func_type)feature_class_schema_delete},


		{GMTT_TILEREF_AFT,       (read_record_func_type)gm_tileref_aft_read,      (delete_record_func_type)gm_tileref_aft_delete},
		{GMTT_COAST_LINE_LFT,    (read_record_func_type)gm_coast_line_lft_read,   (delete_record_func_type)gm_coast_line_lft_delete},
		{GMTT_ROAD_LFT,          (read_record_func_type)gm_road_lft_read,         (delete_record_func_type)gm_road_lft_delete},
		{GMTT_RAILROAD_LFT,         (read_record_func_type) gm_railroad_lft_read,         (delete_record_func_type)gm_railroad_lft_delete},
		{GMTT_POLITICAL_BOUNDARY_AFT,    (read_record_func_type)gm_political_boundary_aft_read,   (delete_record_func_type)gm_political_boundary_aft_delete},
		{GMTT_OCEANSEA_AFT,    (read_record_func_type)gm_oceansea_aft_read,   (delete_record_func_type)gm_oceansea_aft_delete},
		{GMTT_WATER_COURSE_LFT, (read_record_func_type)gm_water_course_lft_read, (delete_record_func_type)gm_water_course_lft_delete},
		{GMTT_INLAND_WATER_AFT, (read_record_func_type)gm_inland_water_aft_read, (delete_record_func_type)gm_inland_water_aft_delete},
		{GMTT_BUILTUP_AREA_AFT, (read_record_func_type)gm_builtup_area_aft_read, (delete_record_func_type)gm_builtup_area_aft_delete},
		{GMTT_BUILTUP_AREA_PFT, (read_record_func_type)gm_builtup_area_pft_read, (delete_record_func_type)gm_builtup_area_pft_delete},
	};
	
	int count;
	int i;
	count = sizeof(table_funcs_list)/sizeof(VPF_TABLE_FUNCS);
	for(i=0; i<count; ++i){
		if(table_funcs_list[i].table_type == type){
			return &table_funcs_list[i];
		}
	}
	printf("error: unsupport type table funcs requested.\n");
	return NULL;
}

/*
void init_vpf(){

}
*/

