/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___LOCATOR_H___
#define ___LOCATOR_H___

#include	"stream.h"

typedef struct location_info {
	int locator_type;
	
	int state;
#define LS_OK 0
#define LS_TIME_UNABLE 0x1
#define LS__X_UNABLE 0x2
#define LS__Y_UNABLE 0x4
#define LS__Z_UNABLE 0x8
#define LS_LOC_UNABLE 0xe
#define LS_UNABLE 0xf
	
	// ʂɎgWn킷refT[oURL
	char * crd;
	
	// ȉ͑ʌʂ̒P
	// unit_uríAPʌn̒`sĂURL
	// ەWPʌngĂꍇ"base"
	char *unit_uri, *x_unit, *y_unit, *z_unit, *sx_unit, *sy_unit, *sz_unit;
	
	// ʌ
	// t͑ʂԁiXLtime=2001.1.1̕bj
	double x, y, z, t;
	
	// ʌ덷
	double sx, sy, sz, st;
} LOCATION_INFO;


typedef union locator_info LOCATOR_INFO;

typedef struct locator_table {
	int (*kill_func)(LOCATOR_INFO*);
	int (*activate_func)(LOCATOR_INFO*);
	int (*inactivate_func)(LOCATOR_INFO*);
} LOCATOR_TABLE;


#define LT_ALLOW_ALL	0xffffffff
#define LOCATOR_INIT_D \
	int locator_type; /*鑪ʕ@*/ \
	void (*listen_func)(LOCATOR_INFO*, const LOCATION_INFO*); /*ʌʂ̒ʒm֐*/ \
	void (*close_func)(LOCATOR_INFO*); /*hCȍIʒm֐*/ \
	int listen_interval; /*ʌʒʒmԊu̍ŏl(b)*/ \
	STREAM *st; /*ʃfoCX蓖ĂĂXg[*/ \
	void	*user_data
	

typedef struct locator_init {
	LOCATOR_INIT_D;
} LOCATOR_INIT;

typedef struct location_info_header {
	LOCATOR_INIT_D;
	LOCATOR_TABLE *tbl;
	int last_time;
	int active;
} LOCATOR_INFO_HEADER;

// -------- LOCATOR_INFO series --------

typedef struct locator_info_gps {
	LOCATOR_INFO_HEADER h;
	int	running;
} LOCATOR_INFO_GPS;

union locator_info {
	LOCATOR_INFO_HEADER h;
	LOCATOR_INFO_GPS gps;
};


LOCATOR_INFO * init_locator(LOCATOR_INFO *info);
int kill_locator(LOCATOR_INFO *info);
void send_location_info(LOCATOR_INFO *li, LOCATION_INFO *info);
void activate_locator(LOCATOR_INFO *li);
void inactivate_locator(LOCATOR_INFO *li);


#endif
