/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx.h"
#include	"ppm_types.h"


XL_SEXP * gb_gmxPNMStatus();

void
init_gmxPNMStatus(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gmxPNMStatus"),
		get_func_prim(gb_gmxPNMStatus,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
gb_gmxPNMStatus(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
PPM_INFO ppm;
XL_SEXP * filename;

	filename = get_el(s,1);
	if ( get_type(filename) != XLT_STRING )
		goto type_missmatch;
	ppm.pi_fd = u_open(n_string(std_cm,filename->string.data),O_RDONLY);
	if ( ppm.pi_fd < 0 ) {
		goto cannot_open;
	}
	read_header(&ppm);
	u_close(ppm.pi_fd);
	return List(
		n_get_symbol("gmxPNMStatus"),
		n_get_string(ppm.pi_type),
		get_integer(ppm.pi_width,0),
		get_integer(ppm.pi_height,0),
		get_integer(ppm.pi_max,0),
		-1);

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxPNMStatus"),
		0);
cannot_open:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxPNMStatus"),
		List(n_get_string("cannot open the file"),
			filename,
			-1));
/*
permission_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxPNMStatus"),
		n_get_string("file path"));
*/
}

