/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx.h"



XL_SEXP * gb_gmxClose();

void
init_gmxClose(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env0,l_string(std_cm,"gmxClose"),
		get_func_prim(gb_gmxClose,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
gb_gmxClose(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * id;
MX_ENTRY * mx_e;
char * e_msg;
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	if ( id == 0 ) {
		e_msg = "id";
		goto inv_param;
	}
	mx_e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
	if ( mx_e == 0 ) {
		e_msg = "id invalid value";
		goto inv_param;
	}
	close_mx_entry(mx_e);
	return 0;
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxClose"),
		0);
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxClose"),
		0);
/*
permission_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxClose"),
		n_get_string("file path"));
*/
}

