/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <gtk/gtk.h>

#include "v/VChooseFile.h"
#include "v/v_serialized_exec.h"

extern "C" {
#include "memory_debug.h"
#include "utils.h"

char * ucd_n_string(const L_CHAR *lc);


void
store_filename(GtkWidget *widget, gpointer user_data)
{
	GtkDialog *file_selector = GTK_DIALOG(user_data);
	gtk_dialog_response(file_selector, GTK_RESPONSE_ACCEPT);
}

char *
_v_choose_file(const L_CHAR *title, const char *default_path)
{
	GtkWidget *dialog;
	char *ret = 0;
	
	dialog = gtk_file_selection_new(title ? ucd_n_string(title) : 0);
	g_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dialog)->ok_button),
		"clicked", G_CALLBACK(store_filename), (gpointer)dialog);
	
	if ( gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT ) {
		const char *filename;
		filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog));
		ret = normalize_delim_str(filename);
	}
	gtk_widget_destroy(dialog);
	return ret;
	
/* ------ for >= GTK 2.4.0 ------
	GtkWidget *dialog;
	char *ret = 0;
	
	dialog = gtk_file_chooser_dialog_new(title ? ucd_n_sting(title) : "",
		NULL,
		GTK_FILE_CHOOSER_ACTION_OPEN,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
		NULL);
	
	if ( gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT ) {
		char *filename;
		filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
		ret = normalize_delim_str(filename);
		g_free(filename);
	}
	gtk_widget_destroy(dialog);
	return ret;
** ------------------------ */
}


char *
v_choose_file(const L_CHAR *title, const char *default_path)
{
	return v_serialized_exec_func(_v_choose_file, title, default_path);
}


}
