// ===========================================================================
//	LStream.h					PowerPlant 2.2.1	1993-2000 Metrowerks Inc.
// ===========================================================================
//
//	Abstract class for reading/writing an ordered sequence of bytes

#ifndef _H_LStream
#define _H_LStream
#pragma once

#include <PP_Prefix.h>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant

// ---------------------------------------------------------------------------

enum EStreamFrom {
	streamFrom_Start = 1,
	streamFrom_End,
	streamFrom_Marker
};

// ---------------------------------------------------------------------------

class	LStream {
public:
					LStream();

					LStream( const LStream& inOriginal );

	LStream&		operator = ( const LStream& inOriginal );

	virtual			~LStream();

	virtual void	SetMarker(
							SInt32			inOffset,
							EStreamFrom		inFromWhere);

	virtual SInt32	GetMarker() const;

	virtual void	SetLength( SInt32 inLength );

	virtual SInt32	GetLength() const;

	bool			AtEnd() const
						{
							return GetMarker() >= GetLength();
						}

						// Write Operations

	virtual ExceptionCode	PutBytes(
								const void		*inBuffer,
								SInt32			&ioByteCount);

	SInt32			WriteData(
							const void		*inBuffer,
							SInt32			inByteCount)
						{
							PutBytes(inBuffer, inByteCount);
							return inByteCount;
						}

	void			WriteBlock(
							const void		*inBuffer,
							SInt32			inByteCount);

	LStream&		operator << ( ConstStringPtr inString)	// Pascal string
						{
							WritePString(inString);
							return (*this);
						}

	LStream&		operator << (const char* inString)
						{
							WriteCString(inString);
							return (*this);
						}

	LStream&		operator << (const Rect	&inRect)
						{
							WriteBlock(&inRect, sizeof(inRect));
							return (*this);
						}

	LStream&		operator << (const Point &inPoint)
						{
							WriteBlock(&inPoint, sizeof(inPoint));
							return (*this);
						}

	LStream&		operator << (Handle inHandle)
						{
							WriteHandle(inHandle);
							return (*this);
						}

	LStream&		operator << (SInt8 inNum)
						{
							WriteBlock(&inNum, sizeof(inNum));
							return (*this);
						}

	LStream&		operator << (UInt8 inNum)
						{
							WriteBlock(&inNum, sizeof(inNum));
							return (*this);
						}

	LStream&		operator << (char inChar)
						{
							WriteBlock(&inChar, sizeof(inChar));
							return (*this);
						}

	LStream&		operator << (SInt16 inNum)
						{
							WriteBlock(&inNum, sizeof(inNum));
							return (*this);
						}

	LStream&		operator << (UInt16 inNum)
						{
							WriteBlock(&inNum, sizeof(inNum));
							return (*this);
						}

	LStream&		operator << (SInt32 inNum)
						{
							WriteBlock(&inNum, sizeof(inNum));
							return (*this);
						}

	LStream&		operator << (UInt32 inNum)
						{
							WriteBlock(&inNum, sizeof(inNum));
							return (*this);
						}

	LStream&		operator << (float inNum)
						{
							WriteBlock(&inNum, sizeof(inNum));
							return (*this);
						}

	LStream&		operator << (double inNum);

	LStream&		operator << (long double inNum)
						{
							(*this) << (double) inNum;
							return (*this);
						}
/*
	LStream&		operator << (short double inNum)
						{
							(*this) << (double) inNum;
							return (*this);
						}
*/
	LStream&		operator << (bool inBool)
						{
							WriteBlock(&inBool, sizeof(inBool));
							return (*this);
						}


						// Read Operations

	virtual ExceptionCode	GetBytes(
								void			*outBuffer,
								SInt32			&ioByteCount);
	virtual SInt32	ReadData(
							void			*outBuffer,
							SInt32			inByteCount)
						{
							GetBytes(outBuffer, inByteCount);
							return inByteCount;
						}

	void			ReadBlock(
							void			*outBuffer,
							SInt32			inByteCount);

	SInt32			PeekData(
							void			*outBuffer,
							SInt32			inByteCount);

	LStream&		operator >> (Str255 outString)
						{
							ReadPString(outString);
							return (*this);
						}

	LStream&		operator >> (char* outString)
						{
							ReadCString(outString);
							return (*this);
						}

	LStream&		operator >> (Rect &outRect)
						{
							ReadBlock(&outRect, sizeof(outRect));
							return (*this);
						}

	LStream&		operator >> (Point &outPoint)
						{
							ReadBlock(&outPoint, sizeof(outPoint));
							return (*this);
						}

	LStream&		operator >> (Handle &outHandle)
						{
							ReadHandle(outHandle);
							return (*this);
						}

	LStream&		operator >> (SInt8 &outNum)
						{
							ReadBlock(&outNum, sizeof(outNum));
							return (*this);
						}

	LStream&		operator >> (UInt8 &outNum)
						{
							ReadBlock(&outNum, sizeof(outNum));
							return (*this);
						}

	LStream&		operator >> (char &outChar)
						{
							ReadBlock(&outChar, sizeof(outChar));
							return (*this);
						}

	LStream&		operator >> (SInt16 &outNum)
						{
							ReadBlock(&outNum, sizeof(outNum));
							return (*this);
						}

	LStream&		operator >> (UInt16 &outNum)
						{
							ReadBlock(&outNum, sizeof(outNum));
							return (*this);
						}

	LStream&		operator >> (SInt32 &outNum)
						{
							ReadBlock(&outNum, sizeof(outNum));
							return (*this);
						}

	LStream&		operator >> (UInt32 &outNum)
						{
							ReadBlock(&outNum, sizeof(outNum));
							return (*this);
						}

	LStream&		operator >> (float &outNum)
						{
							ReadBlock(&outNum, sizeof(outNum));
							return (*this);
						}

	LStream&		operator >> (double &outNum);

	LStream&		operator >> (long double &outNum)
						{
							double	num;
							(*this) >> num;
							outNum = num;
							return (*this);
						}
/*
	LStream&		operator >> (short double &outNum)
						{
							double num;
							(*this) >> num;
							outNum = (short double) num;
							return (*this);
						}
*/
	LStream&		operator >> (bool &outBool)
						{
							ReadBlock(&outBool, sizeof(outBool));
							return (*this);
						}


		// Data-specific read/write functions
		//   There is an equivalent Shift operator for each one
		//	 except WritePtr/ReadPtr (since Ptr is really a char*,
		//	 which is the same as a C string).

	SInt32			WritePtr( Ptr inPtr );
	
	SInt32			ReadPtr( Ptr& outPtr );

	SInt32			WriteHandle( Handle inHandle );
	
	SInt32			ReadHandle( Handle& outHandle );

	SInt32			WritePString( ConstStringPtr inString );
	
	SInt32			ReadPString( Str255 outString );

	SInt32			WriteCString( const char* inString );
	SInt32			ReadCString( char* outString );

protected:
	SInt32			mMarker;
	SInt32			mLength;
};

PP_End_Namespace_PowerPlant


#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif
