// ===========================================================================
//	LPicture.h					PowerPlant 2.2.1	1993-2000 Metrowerks Inc.
// ===========================================================================

#ifndef _H_LPicture
#define _H_LPicture
#pragma once

#include <LView.h>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant

// ---------------------------------------------------------------------------

class	LPicture : public LView {
public:
	enum { class_ID = FOUR_CHAR_CODE('pict') };

						LPicture();
						
						LPicture( const LPicture& inOriginal );
						
						LPicture(
								const SPaneInfo		&inPaneInfo,
								const SViewInfo		&inViewInfo,
								ResIDT				inPICTid);
								
						LPicture( LStream *inStream );
								
						LPicture( ResIDT inPictureID );

	virtual				~LPicture();

	ResIDT				GetPictureID() const	{ return mPICTid; }

	void				SetPictureID( ResIDT inPictureID );

protected:
	ResIDT				mPICTid;

	virtual void		DrawSelf();

private:
	void				InitPicture();
};

PP_End_Namespace_PowerPlant


#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif
