/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xl.h"
#include	"stream.h"
#include	"version.h"
#include	"memory_debug.h"

void gc_tick();

extern VERSION xl_lang_version,xl_proto_version,xl_code_version;
extern VERSION machine_code_version,src_code_version;

void
init_xl(int flags)
{
char * buf;;


	minit();
	init_queue();

	init_proxy();
	init_XLoHTTP_server();

	init_gblisp();
	init_unit();
	init_gc_task();
	init_serverinfo();

	init_interpreter();

	init_session();

	init_log(gblisp_top_env0,gblisp_top_env1);

	init_call_lock();
	
	stream_gc = gc_tick;

	set_version(&src_code_version);
	set_version(&machine_code_version);

	set_version(&xl_lang_version);
	set_version(&xl_proto_version);
	set_version(&xl_code_version);

	buf = d_alloc(strlen(xl_code_version.name)+
		strlen(xl_code_version.version)+20);

	strcpy(buf,xl_code_version.name);
	strcpy(&buf[strlen(buf)],"/");
	strcpy(&buf[strlen(buf)],xl_code_version.version);
	set_setagent_msg(buf);

	d_f_ree(buf);
}
